/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;

public class JacksonTimeModule
extends SimpleModule {
    public JacksonTimeModule() {
        this.addSerializer(Instant.class, new InstantSerializer());
        this.addDeserializer(Instant.class, (JsonDeserializer)new InstantDeserializer());
        this.addSerializer(OffsetDateTime.class, new OffsetDateTimeSerializer());
        this.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new OffsetDateTimeDeserializer());
        this.addSerializer(ZoneId.class, new ZoneIdSerializer());
        this.addDeserializer(ZoneId.class, (JsonDeserializer)new ZoneIdDeserializer());
    }

    public static class ZoneIdDeserializer
    extends FromStringDeserializer<ZoneId> {
        public ZoneIdDeserializer() {
            super(ZoneId.class);
        }

        protected ZoneId _deserialize(String value, DeserializationContext context) throws JsonMappingException {
            try {
                return ZoneId.of(value);
            }
            catch (DateTimeException ex) {
                throw new JsonMappingException("Unknown time zone name: " + value, (Throwable)ex);
            }
        }
    }

    public static class ZoneIdSerializer
    extends JsonSerializer<ZoneId> {
        public void serialize(ZoneId value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.getId());
        }
    }

    public static class OffsetDateTimeDeserializer
    extends FromStringDeserializer<OffsetDateTime> {
        public OffsetDateTimeDeserializer() {
            super(OffsetDateTime.class);
        }

        protected OffsetDateTime _deserialize(String value, DeserializationContext context) throws JsonMappingException {
            try {
                return OffsetDateTime.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(value));
            }
            catch (DateTimeParseException ex) {
                throw new JsonMappingException("Invalid ISO time format: %s" + value, (Throwable)ex);
            }
        }
    }

    public static class OffsetDateTimeSerializer
    extends JsonSerializer<OffsetDateTime> {
        private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssxxx", Locale.ENGLISH);

        public void serialize(OffsetDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(this.formatter.format(value));
        }
    }

    public static class InstantDeserializer
    extends FromStringDeserializer<Instant> {
        public InstantDeserializer() {
            super(Instant.class);
        }

        protected Instant _deserialize(String value, DeserializationContext context) throws JsonMappingException {
            try {
                return Instant.from(DateTimeFormatter.ISO_DATE_TIME.parse(value));
            }
            catch (DateTimeParseException ex) {
                throw new JsonMappingException("Invalid ISO time format: " + value, (Throwable)ex);
            }
        }
    }

    public static class InstantSerializer
    extends JsonSerializer<Instant> {
        private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH).withZone(ZoneId.of("UTC"));

        public void serialize(Instant value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(this.formatter.format(value));
        }
    }
}

