/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class LocalTimeOrInstant {
    private final Instant instant;
    private final LocalDateTime local;

    @JsonCreator
    public static LocalTimeOrInstant fromString(String arg) {
        try {
            LocalDateTime local;
            Instant instant;
            try {
                instant = Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(arg));
                local = null;
            }
            catch (DateTimeParseException ex) {
                local = LocalDateTime.from(DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse(arg));
                instant = null;
            }
            return new LocalTimeOrInstant(instant, local);
        }
        catch (DateTimeException ex) {
            throw new IllegalArgumentException("Invalid timestamp format: " + arg, ex);
        }
    }

    public static LocalTimeOrInstant of(Instant instant) {
        return new LocalTimeOrInstant(instant, null);
    }

    public static LocalTimeOrInstant of(LocalDateTime local) {
        return new LocalTimeOrInstant(null, local);
    }

    private LocalTimeOrInstant(Instant instant, LocalDateTime local) {
        this.instant = instant;
        this.local = local;
    }

    public Instant toInstant(ZoneId timeZoneIfLocalTime) {
        if (this.instant == null) {
            return this.local.atZone(timeZoneIfLocalTime).toInstant();
        }
        return this.instant;
    }

    @JsonValue
    public String toString() {
        if (this.instant != null) {
            return this.instant.toString();
        }
        return this.local.toString();
    }

    public int hashCode() {
        if (this.instant != null) {
            return this.instant.hashCode();
        }
        return this.local.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LocalTimeOrInstant)) {
            return false;
        }
        LocalTimeOrInstant t = (LocalTimeOrInstant)o;
        if (this.instant != null) {
            return t.instant != null && this.instant.equals(t.instant);
        }
        return t.local != null && this.local.equals(t.local);
    }
}

