/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Base64;

public class RestApiKey {
    private final long id;
    private final byte[] secret;

    @JsonCreator
    public static RestApiKey of(String key) {
        String[] fragments = key.split("/", 2);
        if (fragments.length != 2) {
            throw new IllegalArgumentException("Invalid API key format");
        }
        byte[] idData = Base64.getUrlDecoder().decode(fragments[0]);
        if (idData.length != 8) {
            throw new IllegalArgumentException("Invalid API key format");
        }
        long id = ByteBuffer.wrap(idData).getLong();
        byte[] secret = Base64.getUrlDecoder().decode(fragments[1]);
        return new RestApiKey(id, secret);
    }

    public static RestApiKey randomGenerate() {
        SecureRandom random = new SecureRandom();
        long id = random.nextLong();
        byte[] secret = new byte[32];
        random.nextBytes(secret);
        return new RestApiKey(id, secret);
    }

    private RestApiKey(long id, byte[] secret) {
        if (secret.length != 32) {
            throw new IllegalArgumentException("Invalid API key format");
        }
        this.id = id;
        this.secret = secret;
    }

    public long getId() {
        return this.id;
    }

    public String getIdString() {
        byte[] idData = new byte[8];
        ByteBuffer.wrap(idData).putLong(this.id);
        return Base64.getUrlEncoder().encodeToString(idData).replaceAll("=", "");
    }

    public byte[] getSecret() {
        return this.secret;
    }

    @JsonValue
    public String toString() {
        String secretPart = Base64.getUrlEncoder().encodeToString(this.secret).replaceAll("=", "");
        String idPart = this.getIdString();
        return idPart + "/" + secretPart;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RestApiKey)) {
            return false;
        }
        return this.toString().equals(((RestApiKey)o).toString());
    }
}

