/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.digdag.client.api.ImmutableRestDirectDownloadHandle;
import org.immutables.value.Value;

@Value.Immutable
public interface RestDirectDownloadHandle {
    @JsonValue
    public String getUrl();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JsonCreator
    @Deprecated
    public static RestDirectDownloadHandle of(JsonNode node) throws JsonMappingException {
        String url;
        if (node.isTextual()) {
            url = node.asText();
            return RestDirectDownloadHandle.of(url);
        } else {
            if (!node.isObject()) throw new JsonMappingException("Can not deserialize instance of RestDirectDownloadHandle out of malformed node");
            ObjectNode obj = (ObjectNode)node;
            JsonNode v = obj.get("url");
            if (!v.isTextual()) throw new JsonMappingException("Can not deserialize instance of RestDirectDownloadHandle out of malformed object");
            url = v.asText();
        }
        return RestDirectDownloadHandle.of(url);
    }

    public static RestDirectDownloadHandle of(String url) {
        return ImmutableRestDirectDownloadHandle.builder().url(url).build();
    }
}

