/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Optional;
import io.digdag.client.api.Id;
import io.digdag.client.api.IdAndName;
import io.digdag.client.api.ImmutableRestSession;
import io.digdag.client.api.NameOptionalId;
import io.digdag.client.config.Config;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.UUID;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableRestSession.class)
@Value.Immutable
@Value.Enclosing
public interface RestSession {
    public Id getId();

    public IdAndName getProject();

    public NameOptionalId getWorkflow();

    public UUID getSessionUuid();

    public OffsetDateTime getSessionTime();

    public Optional<Attempt> getLastAttempt();

    public static ImmutableRestSession.Builder builder() {
        return ImmutableRestSession.builder();
    }

    @JsonDeserialize(as=ImmutableRestSession.Attempt.class)
    @Value.Immutable
    public static interface Attempt {
        public Id getId();

        public Optional<String> getRetryAttemptName();

        public boolean getDone();

        public boolean getSuccess();

        public boolean getCancelRequested();

        public Config getParams();

        public Instant getCreatedAt();

        public Optional<Instant> getFinishedAt();

        public static ImmutableRestSession.Attempt.Builder builder() {
            return ImmutableRestSession.Attempt.builder();
        }
    }
}

