/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Optional;
import io.digdag.client.api.Id;
import io.digdag.client.api.IdAndName;
import io.digdag.client.api.ImmutableRestSessionAttempt;
import io.digdag.client.api.NameOptionalId;
import io.digdag.client.config.Config;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.UUID;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableRestSessionAttempt.class)
@Value.Immutable
public interface RestSessionAttempt {
    public Id getId();

    @Value.Default
    default public int getIndex() {
        return 0;
    }

    public IdAndName getProject();

    public NameOptionalId getWorkflow();

    public Id getSessionId();

    public UUID getSessionUuid();

    public OffsetDateTime getSessionTime();

    public Optional<String> getRetryAttemptName();

    public boolean getDone();

    public boolean getSuccess();

    public boolean getCancelRequested();

    public Config getParams();

    public Instant getCreatedAt();

    public Optional<Instant> getFinishedAt();

    default public String getStatus() {
        if (this.getSuccess()) {
            return "success";
        }
        if (this.getDone()) {
            if (this.getCancelRequested()) {
                return "killed";
            }
            return "error";
        }
        return "running";
    }

    public static ImmutableRestSessionAttempt.Builder builder() {
        return ImmutableRestSessionAttempt.builder();
    }
}

