/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import io.digdag.client.api.Id;
import io.digdag.client.api.ImmutableRestSessionAttemptRequest;
import io.digdag.client.config.Config;
import java.time.Instant;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableRestSessionAttemptRequest.class)
@Value.Immutable
@Value.Enclosing
public interface RestSessionAttemptRequest {
    public Id getWorkflowId();

    public Instant getSessionTime();

    public Optional<String> getRetryAttemptName();

    public Optional<Resume> getResume();

    public Config getParams();

    public static ImmutableRestSessionAttemptRequest.Builder builder() {
        return ImmutableRestSessionAttemptRequest.builder();
    }

    public static RestSessionAttemptRequest copyWithResume(RestSessionAttemptRequest src, Resume resume) {
        return RestSessionAttemptRequest.builder().from(src).resume((Optional<Resume>)Optional.of((Object)resume)).build();
    }

    @JsonSerialize(as=ResumeFailed.class)
    @JsonDeserialize(as=ImmutableRestSessionAttemptRequest.ResumeFailed.class)
    @Value.Immutable
    public static interface ResumeFailed
    extends Resume {
        @Override
        default public Mode getMode() {
            return Mode.FAILED;
        }

        public static ResumeFailed of(Id attemptId) {
            return ResumeFailed.builder().attemptId(attemptId).build();
        }

        public static ImmutableRestSessionAttemptRequest.ResumeFailed.Builder builder() {
            return ImmutableRestSessionAttemptRequest.ResumeFailed.builder();
        }
    }

    @JsonSerialize(as=ResumeFrom.class)
    @JsonDeserialize(as=ImmutableRestSessionAttemptRequest.ResumeFrom.class)
    @Value.Immutable
    public static interface ResumeFrom
    extends Resume {
        @Override
        default public Mode getMode() {
            return Mode.FROM;
        }

        @JsonProperty(value="from")
        public String getFromTaskNamePattern();

        public static ResumeFrom of(Id attemptId, String fromTaskNamePattern) {
            return ResumeFrom.builder().attemptId(attemptId).fromTaskNamePattern(fromTaskNamePattern).build();
        }

        public static ImmutableRestSessionAttemptRequest.ResumeFrom.Builder builder() {
            return ImmutableRestSessionAttemptRequest.ResumeFrom.builder();
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="mode", visible=false)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ImmutableRestSessionAttemptRequest.ResumeFrom.class, name="from"), @JsonSubTypes.Type(value=ImmutableRestSessionAttemptRequest.ResumeFailed.class, name="failed")})
    public static interface Resume {
        @JsonProperty(value="attemptId")
        public Id getAttemptId();

        @JsonProperty(value="mode")
        public Mode getMode();
    }

    public static enum Mode {
        FROM("from"),
        FAILED("failed");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        @JsonValue
        public String toString() {
            return this.name;
        }
    }
}

