/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Optional;
import io.digdag.client.api.Id;
import io.digdag.client.api.ImmutableRestTask;
import io.digdag.client.config.Config;
import java.time.Instant;
import java.util.List;
import org.immutables.value.Value;

@JsonDeserialize(as=ImmutableRestTask.class)
@Value.Immutable
public interface RestTask {
    public Id getId();

    public String getFullName();

    public Optional<Id> getParentId();

    public Config getConfig();

    public List<Id> getUpstreams();

    public boolean isGroup();

    public String getState();

    @Value.Default
    default public boolean getCancelRequested() {
        return false;
    }

    public Config getExportParams();

    public Config getStoreParams();

    public Config getStateParams();

    public Instant getUpdatedAt();

    public Optional<Instant> getRetryAt();

    public Optional<Instant> getStartedAt();

    public Config getError();

    public static ImmutableRestTask.Builder builder() {
        return ImmutableRestTask.builder();
    }
}

