/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.api;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;

public class SecretValidation {
    private static final String SECRET_KEY_SEGMENT = "[a-zA-Z]|[a-zA-Z][a-zA-Z0-9_\\-]*[a-zA-Z0-9]";
    private static final Pattern SECRET_KEY_PATTERN = Pattern.compile("^([a-zA-Z]|[a-zA-Z][a-zA-Z0-9_\\-]*[a-zA-Z0-9])(\\.([a-zA-Z]|[a-zA-Z][a-zA-Z0-9_\\-]*[a-zA-Z0-9]))*$");
    private static final int MAX_SECRET_KEY_LENGTH = 255;
    private static final int MAX_SECRET_VALUE_LENGTH = 16384;

    private SecretValidation() {
        throw new UnsupportedOperationException();
    }

    public static boolean isValidSecretKey(String key) {
        Preconditions.checkNotNull((Object)key);
        return key.length() <= 255 && SECRET_KEY_PATTERN.matcher(key).matches();
    }

    public static boolean isValidSecretValue(String value) {
        Preconditions.checkNotNull((Object)value);
        return value.getBytes(StandardCharsets.UTF_8).length <= 16384;
    }

    public static boolean isValidSecret(String key, String value) {
        return SecretValidation.isValidSecretKey(key) && SecretValidation.isValidSecretValue(value);
    }
}

