/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.config;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.digdag.client.config.ConfigException;
import io.digdag.client.config.ConfigFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Config {
    protected final ObjectMapper mapper;
    protected final ObjectNode object;

    Config(ObjectMapper mapper) {
        this(mapper, (JsonNode)new ObjectNode(JsonNodeFactory.instance));
    }

    Config(ObjectMapper mapper, JsonNode object) {
        this.mapper = mapper;
        this.object = (ObjectNode)object;
    }

    protected Config(Config config) {
        this.mapper = config.mapper;
        this.object = config.object.deepCopy();
    }

    @JsonCreator
    public static Config deserializeFromJackson(@JacksonInject ObjectMapper mapper, JsonNode object) {
        if (!object.isObject()) {
            throw new RuntimeJsonMappingException("Expected object but got " + object);
        }
        return new Config(mapper, (JsonNode)((ObjectNode)object));
    }

    @JsonValue
    public ObjectNode getInternalObjectNode() {
        return this.object;
    }

    public Config set(String key, Object v) {
        if (v == null) {
            this.remove(key);
        } else {
            this.setNode(key, this.writeObject(v));
        }
        return this;
    }

    public Config setOptional(String key, Optional<?> v) {
        if (v.isPresent()) {
            this.set(key, v.get());
        }
        return this;
    }

    public Config setIfNotSet(String key, Object v) {
        if (!this.has(key) && v != null) {
            this.setNode(key, this.writeObject(v));
        }
        return this;
    }

    public Config setNested(String key, Config v) {
        this.setNode(key, (JsonNode)v.object);
        return this;
    }

    public Config setAll(Config other) {
        for (Map.Entry<String, JsonNode> field : other.getEntries()) {
            this.setNode(field.getKey(), field.getValue());
        }
        return this;
    }

    public Config setAllIfNotSet(Config other) {
        for (Map.Entry<String, JsonNode> field : other.getEntries()) {
            this.setIfNotSet(field.getKey(), field.getValue());
        }
        return this;
    }

    private Iterable<Map.Entry<String, JsonNode>> getEntries() {
        return new Iterable<Map.Entry<String, JsonNode>>(){

            @Override
            public Iterator<Map.Entry<String, JsonNode>> iterator() {
                return Config.this.object.fields();
            }
        };
    }

    public Config remove(String key) {
        this.object.remove(key);
        return this;
    }

    public Config deepCopy() {
        return new Config(this);
    }

    public Config merge(Config other) {
        Config.mergeJsonObject(this.object, other.deepCopy().object);
        return this;
    }

    public Config mergeDefault(Config other) {
        Config.mergeDefaultJsonObject(this.object, other.deepCopy().object);
        return this;
    }

    private static void mergeJsonObject(ObjectNode src, ObjectNode other) {
        Iterator ite = other.fields();
        while (ite.hasNext()) {
            Map.Entry pair = (Map.Entry)ite.next();
            JsonNode s = src.get((String)pair.getKey());
            JsonNode v = (JsonNode)pair.getValue();
            if (v.isObject() && s != null && s.isObject()) {
                Config.mergeJsonObject((ObjectNode)s, (ObjectNode)v);
                continue;
            }
            src.set((String)pair.getKey(), v);
        }
    }

    private static void mergeDefaultJsonObject(ObjectNode src, ObjectNode other) {
        Iterator ite = other.fields();
        while (ite.hasNext()) {
            Map.Entry pair = (Map.Entry)ite.next();
            JsonNode s = src.get((String)pair.getKey());
            JsonNode v = (JsonNode)pair.getValue();
            if (v.isObject() && s != null && s.isObject()) {
                Config.mergeDefaultJsonObject((ObjectNode)s, (ObjectNode)v);
                continue;
            }
            if (s != null) continue;
            src.set((String)pair.getKey(), v);
        }
    }

    private JsonNode writeObject(Object obj) {
        try {
            String value = this.mapper.writeValueAsString(obj);
            return this.mapper.readTree(value);
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public ConfigFactory getFactory() {
        return new ConfigFactory(this.mapper);
    }

    public List<String> getKeys() {
        return ImmutableList.copyOf((Iterator)this.object.fieldNames());
    }

    public boolean isEmpty() {
        return !this.object.fieldNames().hasNext();
    }

    public boolean has(String key) {
        return this.object.has(key);
    }

    public <E> E convert(Class<E> type) {
        return this.readObject(type, (JsonNode)this.object, null);
    }

    public <E> E get(String key, Class<E> type) {
        JsonNode value = this.getNode(key);
        if (value == null) {
            throw new ConfigException("Parameter '" + key + "' is required but not set");
        }
        if (value.isNull()) {
            throw new ConfigException("Parameter '" + key + "' is required but null");
        }
        return this.readObject(type, value, key);
    }

    public Object get(String key, JavaType type) {
        JsonNode value = this.getNode(key);
        if (value == null) {
            throw new ConfigException("Parameter '" + key + "' is required but not set");
        }
        if (value.isNull()) {
            throw new ConfigException("Parameter '" + key + "' is required but null");
        }
        return this.readObject(type, value, key);
    }

    public <E> E get(String key, TypeReference<E> type) {
        return (E)this.get(key, this.mapper.getTypeFactory().constructType(type));
    }

    public <E> E get(String key, Class<E> type, E defaultValue) {
        JsonNode value = this.getNode(key);
        if (value == null || value.isNull()) {
            return defaultValue;
        }
        return this.readObject(type, value, key);
    }

    public Object get(String key, JavaType type, Object defaultValue) {
        JsonNode value = this.getNode(key);
        if (value == null || value.isNull()) {
            return defaultValue;
        }
        return this.readObject(type, value, key);
    }

    public <E> E get(String key, TypeReference<E> type, E defaultValue) {
        return (E)this.get(key, this.mapper.getTypeFactory().constructType(type), defaultValue);
    }

    public <E> Optional<E> getOptional(String key, Class<E> type) {
        return (Optional)this.get(key, this.mapper.getTypeFactory().constructReferenceType(Optional.class, this.mapper.getTypeFactory().constructType(type)), Optional.absent());
    }

    public <E> Optional<E> getOptional(String key, TypeReference<E> type) {
        return (Optional)this.get(key, this.mapper.getTypeFactory().constructType(type), Optional.absent());
    }

    public <E> List<E> getList(String key, Class<E> elementType) {
        return (List)this.get(key, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, elementType));
    }

    public <E> List<E> getListOrEmpty(String key, Class<E> elementType) {
        return (List)this.get(key, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, elementType), ImmutableList.of());
    }

    public <E> List<E> parseList(String key, Class<E> elementType) {
        JsonNode parsed = this.tryParseNested(key);
        if (parsed == null) {
            return this.getList(key, elementType);
        }
        return (List)this.readObject((JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, elementType), parsed, key);
    }

    public <E> List<E> parseListOrGetEmpty(String key, Class<E> elementType) {
        JsonNode parsed = this.tryParseNested(key);
        if (parsed == null) {
            return this.getListOrEmpty(key, elementType);
        }
        return (List)this.readObject((JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, elementType), parsed, key);
    }

    public <K, V> Map<K, V> getMap(String key, Class<K> keyType, Class<V> valueType) {
        return (Map)this.get(key, this.mapper.getTypeFactory().constructParametrizedType(Map.class, Map.class, new Class[]{keyType, valueType}));
    }

    public <K, V> Map<K, V> getMapOrEmpty(String key, Class<K> keyType, Class<V> valueType) {
        return (Map)this.get(key, this.mapper.getTypeFactory().constructParametrizedType(Map.class, Map.class, new Class[]{keyType, valueType}), ImmutableMap.of());
    }

    public Config getNested(String key) {
        JsonNode value = this.getNode(key);
        if (value == null) {
            throw new ConfigException("Parameter '" + key + "' is required but not set");
        }
        if (!value.isObject()) {
            throw new ConfigException("Parameter '" + key + "' must be an object");
        }
        return new Config(this.mapper, (JsonNode)((ObjectNode)value));
    }

    public Config parseNested(String key) {
        JsonNode parsed = this.tryParseNested(key);
        if (parsed == null) {
            return this.getNested(key);
        }
        if (!parsed.isObject()) {
            throw new ConfigException("Parameter '" + key + "' must be an object");
        }
        return new Config(this.mapper, (JsonNode)((ObjectNode)parsed));
    }

    public Config parseNestedOrGetEmpty(String key) {
        JsonNode parsed = this.tryParseNested(key);
        if (parsed == null) {
            return this.getNestedOrGetEmpty(key);
        }
        if (!parsed.isObject()) {
            throw new ConfigException("Parameter '" + key + "' must be an object");
        }
        return new Config(this.mapper, (JsonNode)((ObjectNode)parsed));
    }

    private JsonNode tryParseNested(String key) {
        JsonNode node = this.get(key, JsonNode.class, null);
        if (node == null) {
            return null;
        }
        if (node.isTextual()) {
            try {
                return this.mapper.readTree(node.textValue());
            }
            catch (IOException ex) {
                throw new ConfigException(ex);
            }
        }
        return null;
    }

    public Config getNestedOrSetEmpty(String key) {
        JsonNode value = this.getNode(key);
        if (value == null || value.isNull()) {
            value = this.newObjectNode();
            this.setNode(key, value);
        } else if (!value.isObject()) {
            throw new ConfigException("Parameter '" + key + "' must be an object");
        }
        return new Config(this.mapper, (JsonNode)((ObjectNode)value));
    }

    public Config getNestedOrGetEmpty(String key) {
        JsonNode value = this.getNode(key);
        if (value == null || value.isNull()) {
            value = this.newObjectNode();
        } else if (!value.isObject()) {
            throw new ConfigException("Parameter '" + key + "' must be an object");
        }
        return new Config(this.mapper, (JsonNode)((ObjectNode)value));
    }

    public Config getNestedOrderedOrGetEmpty(String key) {
        JsonNode value = this.getNode(key);
        if (value == null) {
            value = this.newObjectNode();
        } else {
            if (value.isArray()) {
                Config config = new Config(this.mapper);
                Iterator ite = ((ArrayNode)value).elements();
                while (ite.hasNext()) {
                    JsonNode nested = (JsonNode)ite.next();
                    if (!(nested instanceof ObjectNode)) {
                        throw new RuntimeJsonMappingException("Expected object but got " + nested);
                    }
                    config.setAll(new Config(this.mapper, (JsonNode)((ObjectNode)nested)));
                }
                return config;
            }
            if (!value.isObject()) {
                throw new ConfigException("Parameter '" + key + "' must be an object or array of objects");
            }
        }
        return new Config(this.mapper, (JsonNode)((ObjectNode)value));
    }

    public Optional<Config> getOptionalNested(String key) {
        JsonNode value = this.getNode(key);
        if (value == null || value.isNull()) {
            return Optional.absent();
        }
        return Optional.of((Object)this.getNested(key));
    }

    private ObjectNode newObjectNode() {
        return this.object.objectNode();
    }

    protected JsonNode getNode(String key) {
        return this.object.get(key);
    }

    protected void setNode(String key, JsonNode value) {
        this.object.set(key, value);
    }

    private <E> E readObject(Class<E> type, JsonNode value, String key) {
        try {
            return (E)this.mapper.readValue(value.traverse(), type);
        }
        catch (Exception ex) {
            throw this.propagateConvertException(ex, Config.typeNameOf(type), value, key);
        }
    }

    private Object readObject(JavaType type, JsonNode value, String key) {
        try {
            return this.mapper.readValue(value.traverse(), type);
        }
        catch (Exception ex) {
            throw this.propagateConvertException(ex, Config.typeNameOf(type), value, key);
        }
    }

    private ConfigException propagateConvertException(Exception ex, String typeName, JsonNode value, String key) {
        Throwables.propagateIfInstanceOf((Throwable)ex, ConfigException.class);
        String message = String.format(Locale.ENGLISH, "Expected %s for key '%s' but got %s (%s)", typeName, key, this.jsonSample(value), Config.typeNameOf(value));
        return new ConfigException(message, ex);
    }

    private static String typeNameOf(Class<?> type) {
        if (type.equals(String.class)) {
            return "string type";
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return "integer (int) type";
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return "integer (long) type";
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return "'true' or 'false'";
        }
        return type.toString();
    }

    private static String typeNameOf(JavaType type) {
        if (List.class.isAssignableFrom(type.getRawClass())) {
            return "array type";
        }
        if (Map.class.isAssignableFrom(type.getRawClass())) {
            return "object type";
        }
        return type.toString();
    }

    private static String typeNameOf(JsonNode value) {
        switch (value.getNodeType()) {
            case NULL: {
                return "null";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case NUMBER: {
                return "number";
            }
            case ARRAY: {
                return "array";
            }
            case OBJECT: {
                return "object";
            }
            case STRING: {
                return "string";
            }
            case BINARY: {
                return "binary";
            }
        }
        return value.getNodeType().toString();
    }

    private String jsonSample(JsonNode value) {
        String json = value.toString();
        if (json.length() < 100) {
            return json;
        }
        return json.substring(0, 97) + "...";
    }

    public String toString() {
        return this.object.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Config)) {
            return false;
        }
        return this.object.equals((Object)((Config)other).object);
    }

    public int hashCode() {
        return this.object.hashCode();
    }
}

