/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import io.digdag.client.config.ConfigFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ConfigElement {
    private final ObjectNode object;

    public static ConfigElement copyOf(Config mutableConfig) {
        return new ConfigElement(mutableConfig.object.deepCopy());
    }

    @JsonCreator
    public static ConfigElement of(ObjectNode node) {
        return new ConfigElement(node.deepCopy());
    }

    public static ConfigElement empty() {
        return new ConfigElement(JsonNodeFactory.instance.objectNode());
    }

    public static ConfigElement ofMap(Map<String, String> map) {
        ObjectNode js = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, String> pair : map.entrySet()) {
            js.put(pair.getKey(), pair.getValue());
        }
        return new ConfigElement(js);
    }

    public static ConfigElement fromJson(String json) {
        JsonNode js;
        try {
            js = new ObjectMapper().readTree(json);
        }
        catch (IOException ex) {
            throw new ConfigException(ex);
        }
        if (!js.isObject()) {
            throw new ConfigException("Expected an object but got " + js);
        }
        return new ConfigElement((ObjectNode)js);
    }

    private ConfigElement(ObjectNode node) {
        this.object = node.deepCopy();
    }

    public Config toConfig(ConfigFactory factory) {
        return new Config(factory.objectMapper, (JsonNode)this.object.deepCopy());
    }

    public Properties toProperties() {
        Properties props = new Properties();
        Iterator ite = this.object.fields();
        while (ite.hasNext()) {
            Map.Entry pair = (Map.Entry)ite.next();
            JsonNode value = (JsonNode)pair.getValue();
            if (value.isTextual()) {
                props.put(pair.getKey(), value.asText());
                continue;
            }
            props.put(pair.getKey(), value.toString());
        }
        return props;
    }

    @JsonValue
    @Deprecated
    public ObjectNode getObjectNode() {
        return this.object;
    }

    public String toString() {
        return this.object.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConfigElement)) {
            return false;
        }
        return this.object.equals((Object)((ConfigElement)other).object);
    }

    public int hashCode() {
        return this.object.hashCode();
    }
}

