/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigException;
import java.io.IOException;
import javax.inject.Inject;

public class ConfigFactory {
    final ObjectMapper objectMapper;

    @Inject
    public ConfigFactory(ObjectMapper typeConverter) {
        this.objectMapper = typeConverter;
    }

    public Config create() {
        return new Config(this.objectMapper);
    }

    public Config create(Object other) {
        return this.create().set("_", other).getNested("_");
    }

    public Config fromJsonString(String json) {
        try {
            return new Config(this.objectMapper, this.objectMapper.readTree(json));
        }
        catch (IOException ex) {
            throw new ConfigException(ex);
        }
    }
}

