/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.client.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class ConfigKey {
    private static Pattern VALID_NAME = Pattern.compile("[a-zA-Z0-9_]+");
    private static Pattern VALID_EXPRESSION = Pattern.compile("[a-zA-Z0-9_]+(\\.[a-zA-Z0-9_]+)*");
    private List<String> names;

    @JsonCreator
    public static ConfigKey parse(String expr) {
        if (!VALID_EXPRESSION.matcher(expr).matches()) {
            throw new IllegalArgumentException("Config key expression is invalid. Currently, only [a-zA-Z0-9_] characters are supported: " + expr);
        }
        String[] names = expr.split("\\.", -1);
        return ConfigKey.of(names);
    }

    public static ConfigKey of(String ... names) {
        return ConfigKey.of(Arrays.asList(names));
    }

    public static ConfigKey of(List<String> names) {
        return new ConfigKey(names);
    }

    private ConfigKey(List<String> names) {
        Preconditions.checkArgument((!names.isEmpty() ? 1 : 0) != 0, (Object)"Names must not be empty");
        for (String key : names) {
            Preconditions.checkArgument((boolean)VALID_NAME.matcher(key).matches(), (Object)"Invalid name");
        }
        this.names = ImmutableList.copyOf(names);
    }

    public List<String> getNestNames() {
        return this.names.subList(0, this.names.size() - 1);
    }

    public String getLastName() {
        return this.names.get(this.names.size() - 1);
    }

    public List<String> getNames() {
        return this.names;
    }

    @JsonValue
    public String toString() {
        return String.join((CharSequence)".", this.names);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConfigKey)) {
            return false;
        }
        ConfigKey o = (ConfigKey)other;
        return Objects.equals(this.names, o.names);
    }

    public int hashCode() {
        return this.names.hashCode();
    }
}

