/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.EditShape;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryAccelerators;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.MultiPointImpl;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.RasterizedGeometry2D;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.SegmentIteratorImpl;

class Clipper {
    Envelope2D m_extent;
    EditShape m_shape;
    int m_geometry;
    int m_vertices_on_extent_index;
    AttributeStreamOfInt32 m_vertices_on_extent;

    int checkSegmentIntersection_(Envelope2D seg_env, int side, double clip_value) {
        switch (side) {
            case 0: {
                if (seg_env.xmin < clip_value && seg_env.xmax <= clip_value) {
                    return 0;
                }
                if (seg_env.xmin >= clip_value) {
                    return 1;
                }
                return -1;
            }
            case 1: {
                if (seg_env.ymin < clip_value && seg_env.ymax <= clip_value) {
                    return 0;
                }
                if (seg_env.ymin >= clip_value) {
                    return 1;
                }
                return -1;
            }
            case 2: {
                if (seg_env.xmin >= clip_value && seg_env.xmax > clip_value) {
                    return 0;
                }
                if (seg_env.xmax <= clip_value) {
                    return 1;
                }
                return -1;
            }
            case 3: {
                if (seg_env.ymin >= clip_value && seg_env.ymax > clip_value) {
                    return 0;
                }
                if (seg_env.ymax <= clip_value) {
                    return 1;
                }
                return -1;
            }
        }
        assert (false);
        return 0;
    }

    MultiPath clipMultiPath2_(MultiPath multi_path_in, double tolerance, double densify_dist) {
        boolean b_is_polygon;
        boolean bl = b_is_polygon = multi_path_in.getType() == Geometry.Type.Polygon;
        if (b_is_polygon) {
            return this.clipPolygon2_((Polygon)multi_path_in, tolerance, densify_dist);
        }
        return this.clipPolyline_((Polyline)multi_path_in, tolerance);
    }

    MultiPath clipPolygon2_(Polygon polygon_in, double tolerance, double densify_dist) {
        if (this.m_extent.getWidth() == 0.0 || this.m_extent.getHeight() == 0.0) {
            return (MultiPath)polygon_in.createInstance();
        }
        Envelope2D orig_env2D = new Envelope2D();
        polygon_in.queryLooseEnvelope(orig_env2D);
        this.m_geometry = this.m_shape.addGeometry(polygon_in);
        Envelope2D seg_env = new Envelope2D();
        Envelope2D sub_seg_env = new Envelope2D();
        Point2D pt_1 = new Point2D();
        Point2D pt_2 = new Point2D();
        double[] result_ordinates = new double[9];
        double[] parameters = new double[9];
        SegmentBuffer sub_segment_buffer = new SegmentBuffer();
        Line line = new Line();
        AttributeStreamOfInt32 delete_candidates = new AttributeStreamOfInt32(0);
        delete_candidates.reserve(Math.min(100, polygon_in.getPointCount()));
        boolean b_all_outside = false;
        for (int iclip_plane = 0; !b_all_outside && iclip_plane < 4; ++iclip_plane) {
            boolean b_intersects_plane = false;
            boolean b_axis_x = (iclip_plane & 1) != 0;
            double clip_value = 0.0;
            switch (iclip_plane) {
                case 0: {
                    clip_value = this.m_extent.xmin;
                    boolean bl = b_intersects_plane = orig_env2D.xmin <= clip_value && orig_env2D.xmax >= clip_value;
                    assert (b_intersects_plane || clip_value < orig_env2D.xmin);
                    break;
                }
                case 1: {
                    clip_value = this.m_extent.ymin;
                    boolean bl = b_intersects_plane = orig_env2D.ymin <= clip_value && orig_env2D.ymax >= clip_value;
                    assert (b_intersects_plane || clip_value < orig_env2D.ymin);
                    break;
                }
                case 2: {
                    clip_value = this.m_extent.xmax;
                    boolean bl = b_intersects_plane = orig_env2D.xmin <= clip_value && orig_env2D.xmax >= clip_value;
                    assert (b_intersects_plane || clip_value > orig_env2D.xmax);
                    break;
                }
                case 3: {
                    clip_value = this.m_extent.ymax;
                    boolean bl = b_intersects_plane = orig_env2D.ymin <= clip_value && orig_env2D.ymax >= clip_value;
                    assert (b_intersects_plane || clip_value > orig_env2D.ymax);
                    break;
                }
            }
            if (!b_intersects_plane) continue;
            b_all_outside = true;
            int path = this.m_shape.getFirstPath(this.m_geometry);
            while (path != -1) {
                int next_vertex;
                int first;
                int inside = -1;
                int firstinside = -1;
                int vertex = first = this.m_shape.getFirstVertex(path);
                do {
                    Segment segment;
                    if ((segment = this.m_shape.getSegment(vertex)) == null) {
                        segment = line;
                        this.m_shape.getXY(vertex, pt_1);
                        segment.setStartXY(pt_1);
                        this.m_shape.getXY(this.m_shape.getNextVertex(vertex), pt_2);
                        segment.setEndXY(pt_2);
                    }
                    segment.queryEnvelope2D(seg_env);
                    int seg_plane_intersection_status = this.checkSegmentIntersection_(seg_env, iclip_plane, clip_value);
                    int split_count = 0;
                    next_vertex = -1;
                    if (seg_plane_intersection_status == -1) {
                        int count = segment.intersectionWithAxis2D(b_axis_x, clip_value, result_ordinates, parameters);
                        if (count > 0) {
                            split_count = this.m_shape.splitSegment(vertex, parameters, count);
                        } else {
                            assert (count == 0);
                            split_count = 0;
                        }
                        ++split_count;
                        int split_vert = vertex;
                        int next_split_vert = this.m_shape.getNextVertex(split_vert);
                        for (int i = 0; i < split_count; ++i) {
                            this.m_shape.getXY(split_vert, pt_1);
                            this.m_shape.getXY(next_split_vert, pt_2);
                            Segment sub_seg = this.m_shape.getSegment(split_vert);
                            if (sub_seg == null) {
                                sub_seg = line;
                                sub_seg.setStartXY(pt_1);
                                sub_seg.setEndXY(pt_2);
                            }
                            sub_seg.queryEnvelope2D(sub_seg_env);
                            int sub_segment_plane_intersection_status = this.checkSegmentIntersection_(sub_seg_env, iclip_plane, clip_value);
                            if (sub_segment_plane_intersection_status == -1) {
                                double d_2;
                                double d_1;
                                if (!b_axis_x) {
                                    assert (pt_1.x < clip_value && pt_2.x > clip_value || pt_1.x > clip_value && pt_2.x < clip_value);
                                    d_1 = Math.abs(pt_1.x - clip_value);
                                    if (d_1 < (d_2 = Math.abs(pt_2.x - clip_value))) {
                                        pt_1.x = clip_value;
                                        this.m_shape.setXY(split_vert, pt_1);
                                    } else {
                                        pt_2.x = clip_value;
                                        this.m_shape.setXY(next_split_vert, pt_2);
                                    }
                                } else {
                                    assert (pt_1.y < clip_value && pt_2.y > clip_value || pt_1.y > clip_value && pt_2.y < clip_value);
                                    d_1 = Math.abs(pt_1.y - clip_value);
                                    if (d_1 < (d_2 = Math.abs(pt_2.y - clip_value))) {
                                        pt_1.y = clip_value;
                                        this.m_shape.setXY(split_vert, pt_1);
                                    } else {
                                        pt_2.y = clip_value;
                                        this.m_shape.setXY(next_split_vert, pt_2);
                                    }
                                }
                                sub_seg = this.m_shape.getSegment(split_vert);
                                if (sub_seg == null) {
                                    sub_seg = line;
                                    sub_seg.setStartXY(pt_1);
                                    sub_seg.setEndXY(pt_2);
                                }
                                sub_seg.queryEnvelope2D(sub_seg_env);
                                sub_segment_plane_intersection_status = this.checkSegmentIntersection_(sub_seg_env, iclip_plane, clip_value);
                            }
                            assert (sub_segment_plane_intersection_status != -1);
                            int old_inside = inside;
                            inside = sub_segment_plane_intersection_status;
                            if (firstinside == -1) {
                                firstinside = inside;
                            }
                            if (!(old_inside == 0 && inside == 1 || old_inside == 1 && inside == 0 || old_inside != 0 || inside != 0)) {
                                delete_candidates.add(split_vert);
                            }
                            if (inside == 1) {
                                b_all_outside = false;
                            }
                            next_vertex = split_vert = next_split_vert;
                            next_split_vert = this.m_shape.getNextVertex(next_split_vert);
                        }
                    }
                    if (split_count != 0) continue;
                    assert (seg_plane_intersection_status != -1);
                    int old_inside = inside;
                    inside = seg_plane_intersection_status;
                    if (firstinside == -1) {
                        firstinside = inside;
                    }
                    if (!(old_inside == 0 && inside == 1 || old_inside == 1 && inside == 0 || old_inside != 0 || inside != 0)) {
                        delete_candidates.add(vertex);
                    }
                    if (inside == 1) {
                        b_all_outside = false;
                    }
                    next_vertex = this.m_shape.getNextVertex(vertex);
                } while ((vertex = next_vertex) != first);
                if (firstinside == 0 && inside == 0) {
                    delete_candidates.add(first);
                }
                int n = delete_candidates.size();
                for (int i = 0; i < n; ++i) {
                    int delete_vert = delete_candidates.get(i);
                    this.m_shape.removeVertex(delete_vert, false);
                }
                delete_candidates.clear(false);
                if (this.m_shape.getPathSize(path) < 3) {
                    path = this.m_shape.removePath(path);
                    continue;
                }
                path = this.m_shape.getNextPath(path);
            }
        }
        if (b_all_outside) {
            return (MultiPath)polygon_in.createInstance();
        }
        this.resolveBoundaryOverlaps_();
        if (densify_dist > 0.0) {
            this.densifyAlongClipExtent_(densify_dist);
        }
        return (MultiPath)this.m_shape.getGeometry(this.m_geometry);
    }

    MultiPath clipPolyline_(Polyline polyline_in, double tolerance) {
        Envelope2D seg_env = new Envelope2D();
        Envelope2D sub_seg_env = new Envelope2D();
        double[] result_ordinates = new double[9];
        double[] parameters = new double[9];
        SegmentBuffer sub_segment_buffer = new SegmentBuffer();
        MultiPath result_poly = polyline_in;
        Envelope2D orig_env2D = new Envelope2D();
        polyline_in.queryLooseEnvelope(orig_env2D);
        for (int iclip_plane = 0; iclip_plane < 4; ++iclip_plane) {
            boolean b_intersects_plane = false;
            boolean b_axis_x = (iclip_plane & 1) != 0;
            double clip_value = 0.0;
            switch (iclip_plane) {
                case 0: {
                    clip_value = this.m_extent.xmin;
                    boolean bl = b_intersects_plane = orig_env2D.xmin <= clip_value && orig_env2D.xmax >= clip_value;
                    assert (b_intersects_plane || clip_value < orig_env2D.xmin);
                    break;
                }
                case 1: {
                    clip_value = this.m_extent.ymin;
                    boolean bl = b_intersects_plane = orig_env2D.ymin <= clip_value && orig_env2D.ymax >= clip_value;
                    assert (b_intersects_plane || clip_value < orig_env2D.ymin);
                    break;
                }
                case 2: {
                    clip_value = this.m_extent.xmax;
                    boolean bl = b_intersects_plane = orig_env2D.xmin <= clip_value && orig_env2D.xmax >= clip_value;
                    assert (b_intersects_plane || clip_value > orig_env2D.xmax);
                    break;
                }
                case 3: {
                    clip_value = this.m_extent.ymax;
                    boolean bl = b_intersects_plane = orig_env2D.ymin <= clip_value && orig_env2D.ymax >= clip_value;
                    assert (b_intersects_plane || clip_value > orig_env2D.ymax);
                    break;
                }
            }
            if (!b_intersects_plane) continue;
            Polyline src_poly = result_poly;
            result_poly = (MultiPath)polyline_in.createInstance();
            MultiPathImpl mp_impl_src = (MultiPathImpl)src_poly._getImpl();
            SegmentIteratorImpl seg_iter = mp_impl_src.querySegmentIterator();
            seg_iter.resetToFirstPath();
            Point2D pt = new Point2D();
            while (seg_iter.nextPath()) {
                int inside = -1;
                boolean b_start_new_path = true;
                while (seg_iter.hasNextSegment()) {
                    Segment segment = seg_iter.nextSegment();
                    segment.queryEnvelope2D(seg_env);
                    int seg_plane_intersection_status = this.checkSegmentIntersection_(seg_env, iclip_plane, clip_value);
                    if (seg_plane_intersection_status == -1) {
                        int count = segment.intersectionWithAxis2D(b_axis_x, clip_value, result_ordinates, parameters);
                        if (count <= 0) continue;
                        double t0 = 0.0;
                        Point2D pt_prev = segment.getStartXY();
                        for (int i = 0; i <= count; ++i) {
                            double t;
                            double d = t = i < count ? parameters[i] : 1.0;
                            if (t0 == t) continue;
                            segment.cut(t0, t, sub_segment_buffer);
                            Segment sub_seg = sub_segment_buffer.get();
                            sub_seg.setStartXY(pt_prev);
                            if (i < count) {
                                if (b_axis_x) {
                                    pt.x = result_ordinates[i];
                                    pt.y = clip_value;
                                } else {
                                    pt.x = clip_value;
                                    pt.y = result_ordinates[i];
                                }
                                sub_seg.setEndXY(pt);
                            }
                            sub_seg.queryEnvelope2D(sub_seg_env);
                            int sub_segment_plane_intersection_status = this.checkSegmentIntersection_(sub_seg_env, iclip_plane, clip_value);
                            if (sub_segment_plane_intersection_status == -1) {
                                double d_2;
                                double d_1;
                                Point2D pt_1 = sub_seg.getStartXY();
                                Point2D pt_2 = sub_seg.getEndXY();
                                if (!b_axis_x) {
                                    assert (pt_1.x < clip_value && pt_2.x > clip_value || pt_1.x > clip_value && pt_2.x < clip_value);
                                    d_1 = Math.abs(pt_1.x - clip_value);
                                    if (d_1 < (d_2 = Math.abs(pt_2.x - clip_value))) {
                                        pt_1.x = clip_value;
                                        sub_seg.setStartXY(pt_1);
                                    } else {
                                        pt_2.x = clip_value;
                                        sub_seg.setEndXY(pt_2);
                                    }
                                } else {
                                    assert (pt_1.y < clip_value && pt_2.y > clip_value || pt_1.y > clip_value && pt_2.y < clip_value);
                                    d_1 = Math.abs(pt_1.y - clip_value);
                                    if (d_1 < (d_2 = Math.abs(pt_2.y - clip_value))) {
                                        pt_1.y = clip_value;
                                        sub_seg.setStartXY(pt_1);
                                    } else {
                                        pt_2.y = clip_value;
                                        sub_seg.setEndXY(pt_2);
                                    }
                                }
                                sub_seg.queryEnvelope2D(sub_seg_env);
                                sub_segment_plane_intersection_status = this.checkSegmentIntersection_(sub_seg_env, iclip_plane, clip_value);
                            }
                            assert (sub_segment_plane_intersection_status != -1);
                            pt_prev = sub_seg.getEndXY();
                            t0 = t;
                            inside = sub_segment_plane_intersection_status;
                            if (inside == 1) {
                                result_poly.addSegment(sub_seg, b_start_new_path);
                                b_start_new_path = false;
                                continue;
                            }
                            b_start_new_path = true;
                        }
                        continue;
                    }
                    inside = seg_plane_intersection_status;
                    if (inside == 1) {
                        result_poly.addSegment(segment, b_start_new_path);
                        b_start_new_path = false;
                        continue;
                    }
                    b_start_new_path = true;
                }
            }
        }
        return result_poly;
    }

    void resolveBoundaryOverlaps_() {
        this.m_vertices_on_extent_index = -1;
        this.splitSegments_(false, this.m_extent.xmin);
        this.splitSegments_(false, this.m_extent.xmax);
        this.splitSegments_(true, this.m_extent.ymin);
        this.splitSegments_(true, this.m_extent.ymax);
        this.m_vertices_on_extent.resize(0);
        this.m_vertices_on_extent.reserve(100);
        this.m_vertices_on_extent_index = this.m_shape.createUserIndex();
        Point2D pt = new Point2D();
        int path = this.m_shape.getFirstPath(this.m_geometry);
        while (path != -1) {
            int vertex = this.m_shape.getFirstVertex(path);
            int nvert = this.m_shape.getPathSize(path);
            for (int ivert = 0; ivert < nvert; ++ivert) {
                this.m_shape.getXY(vertex, pt);
                if (this.m_extent.xmin == pt.x || this.m_extent.xmax == pt.x || this.m_extent.ymin == pt.y || this.m_extent.ymax == pt.y) {
                    this.m_shape.setUserIndex(vertex, this.m_vertices_on_extent_index, this.m_vertices_on_extent.size());
                    this.m_vertices_on_extent.add(vertex);
                }
                vertex = this.m_shape.getNextVertex(vertex);
            }
            path = this.m_shape.getNextPath(path);
        }
        this.resolveOverlaps_(false, this.m_extent.xmin);
        this.resolveOverlaps_(false, this.m_extent.xmax);
        this.resolveOverlaps_(true, this.m_extent.ymin);
        this.resolveOverlaps_(true, this.m_extent.ymax);
        this.fixPaths_();
    }

    void densifyAlongClipExtent_(double densify_dist) {
        assert (densify_dist > 0.0);
        Point2D pt_1 = new Point2D();
        Point2D pt_2 = new Point2D();
        double[] split_scalars = new double[2048];
        int path = this.m_shape.getFirstPath(this.m_geometry);
        while (path != -1) {
            int first_vertex;
            int vertex = first_vertex = this.m_shape.getFirstVertex(path);
            do {
                int next_vertex = this.m_shape.getNextVertex(vertex);
                this.m_shape.getXY(vertex, pt_1);
                int b_densify_x = -1;
                if (pt_1.x == this.m_extent.xmin) {
                    this.m_shape.getXY(next_vertex, pt_2);
                    if (pt_2.x == this.m_extent.xmin) {
                        b_densify_x = 1;
                    }
                } else if (pt_1.x == this.m_extent.xmax) {
                    this.m_shape.getXY(next_vertex, pt_2);
                    if (pt_2.x == this.m_extent.xmax) {
                        b_densify_x = 1;
                    }
                }
                if (pt_1.y == this.m_extent.ymin) {
                    this.m_shape.getXY(next_vertex, pt_2);
                    if (pt_2.y == this.m_extent.ymin) {
                        b_densify_x = 0;
                    }
                } else if (pt_1.y == this.m_extent.ymax) {
                    this.m_shape.getXY(next_vertex, pt_2);
                    if (pt_2.y == this.m_extent.ymax) {
                        b_densify_x = 0;
                    }
                }
                if (b_densify_x == -1) {
                    vertex = next_vertex;
                    continue;
                }
                double len2 = Point2D.distance(pt_1, pt_2);
                int num = (int)Math.min(Math.ceil(len2 / densify_dist), 2048.0);
                if (num <= 1) {
                    vertex = next_vertex;
                    continue;
                }
                for (int i = 1; i < num; ++i) {
                    split_scalars[i - 1] = 1.0 * (double)i / (double)num;
                }
                int actual_splits = this.m_shape.splitSegment(vertex, split_scalars, num - 1);
                assert (actual_splits == num - 1);
                vertex = next_vertex;
            } while (vertex != first_vertex);
            path = this.m_shape.getNextPath(path);
        }
    }

    void splitSegments_(boolean b_axis_x, double clip_value) {
        int usage_index = this.m_shape.createUserIndex();
        Point2D pt = new Point2D();
        AttributeStreamOfInt32 sorted_vertices = new AttributeStreamOfInt32(0);
        sorted_vertices.reserve(100);
        int path = this.m_shape.getFirstPath(this.m_geometry);
        while (path != -1) {
            int vertex = this.m_shape.getFirstVertex(path);
            int nvert = this.m_shape.getPathSize(path);
            for (int ivert = 0; ivert < nvert; ++ivert) {
                int next_vertex = this.m_shape.getNextVertex(vertex);
                this.m_shape.getXY(vertex, pt);
                if (b_axis_x ? pt.y == clip_value : pt.x == clip_value) {
                    this.m_shape.getXY(next_vertex, pt);
                    if (b_axis_x ? pt.y == clip_value : pt.x == clip_value) {
                        if (this.m_shape.getUserIndex(vertex, usage_index) != 1) {
                            sorted_vertices.add(vertex);
                            this.m_shape.setUserIndex(vertex, usage_index, 1);
                        }
                        if (this.m_shape.getUserIndex(next_vertex, usage_index) != 1) {
                            sorted_vertices.add(next_vertex);
                            this.m_shape.setUserIndex(next_vertex, usage_index, 1);
                        }
                    }
                }
                vertex = next_vertex;
            }
            path = this.m_shape.getNextPath(path);
        }
        this.m_shape.removeUserIndex(usage_index);
        if (sorted_vertices.size() < 3) {
            return;
        }
        sorted_vertices.Sort(0, sorted_vertices.size(), new ClipperVertexComparer(this));
        Point2D pt_tmp = new Point2D();
        Point2D pt_0 = new Point2D();
        Point2D pt_1 = new Point2D();
        pt_0.setNaN();
        int index_0 = -1;
        AttributeStreamOfInt32 active_intervals = new AttributeStreamOfInt32(0);
        AttributeStreamOfInt32 new_active_intervals = new AttributeStreamOfInt32(0);
        int node1 = this.m_shape.createUserIndex();
        int node2 = this.m_shape.createUserIndex();
        int n = sorted_vertices.size();
        for (int index = 0; index < n; ++index) {
            int vert = sorted_vertices.get(index);
            this.m_shape.getXY(vert, pt);
            if (pt.isEqual(pt_0)) continue;
            if (index_0 == -1) {
                index_0 = index;
                pt_0.setCoords(pt);
                continue;
            }
            for (int i = index_0; i < index; ++i) {
                int v = sorted_vertices.get(i);
                int nextv = this.m_shape.getNextVertex(v);
                int prevv = this.m_shape.getPrevVertex(v);
                boolean bAdded = false;
                if (this.compareVertices_(v, nextv) < 0) {
                    this.m_shape.getXY(nextv, pt_tmp);
                    if (b_axis_x ? pt_tmp.y == clip_value : pt_tmp.x == clip_value) {
                        active_intervals.add(v);
                        bAdded = true;
                        this.m_shape.setUserIndex(v, node2, 1);
                    }
                }
                if (this.compareVertices_(v, prevv) >= 0) continue;
                this.m_shape.getXY(prevv, pt_tmp);
                if (!(b_axis_x ? pt_tmp.y == clip_value : pt_tmp.x == clip_value)) continue;
                if (!bAdded) {
                    active_intervals.add(v);
                }
                this.m_shape.setUserIndex(v, node1, 1);
            }
            int na = active_intervals.size();
            for (int ia = 0; ia < na; ++ia) {
                int v_1;
                int split_count;
                double active_segment_length;
                double[] t;
                int v = active_intervals.get(ia);
                int n_1 = this.m_shape.getUserIndex(v, node1);
                int n_2 = this.m_shape.getUserIndex(v, node2);
                if (n_1 == 1) {
                    int prevv = this.m_shape.getPrevVertex(v);
                    this.m_shape.getXY(prevv, pt_1);
                    t = new double[]{0.0};
                    if (!pt_1.isEqual(pt)) {
                        active_segment_length = Point2D.distance(pt_0, pt_1);
                        t[0] = Point2D.distance(pt_1, pt) / active_segment_length;
                        assert (t[0] >= 0.0 && t[0] <= 1.0);
                        if (t[0] == 0.0) {
                            t[0] = NumberUtils.doubleEps();
                        } else if (t[0] == 1.0) {
                            t[0] = 1.0 - NumberUtils.doubleEps();
                            assert (t[0] != 1.0);
                        }
                        split_count = this.m_shape.splitSegment(prevv, t, 1);
                        assert (split_count > 0);
                        v_1 = this.m_shape.getPrevVertex(v);
                        this.m_shape.setXY(v_1, pt);
                        new_active_intervals.add(v_1);
                        this.m_shape.setUserIndex(v_1, node1, 1);
                        this.m_shape.setUserIndex(v_1, node2, -1);
                    }
                }
                if (n_2 != 1) continue;
                int nextv = this.m_shape.getNextVertex(v);
                this.m_shape.getXY(nextv, pt_1);
                t = new double[]{0.0};
                if (pt_1.isEqual(pt)) continue;
                active_segment_length = Point2D.distance(pt_0, pt_1);
                t[0] = Point2D.distance(pt_0, pt) / active_segment_length;
                assert (t[0] >= 0.0 && t[0] <= 1.0);
                if (t[0] == 0.0) {
                    t[0] = NumberUtils.doubleEps();
                } else if (t[0] == 1.0) {
                    t[0] = 1.0 - NumberUtils.doubleEps();
                    assert (t[0] != 1.0);
                }
                split_count = this.m_shape.splitSegment(v, t, 1);
                assert (split_count > 0);
                v_1 = this.m_shape.getNextVertex(v);
                this.m_shape.setXY(v_1, pt);
                new_active_intervals.add(v_1);
                this.m_shape.setUserIndex(v_1, node1, -1);
                this.m_shape.setUserIndex(v_1, node2, 1);
            }
            AttributeStreamOfInt32 tmp = active_intervals;
            active_intervals = new_active_intervals;
            new_active_intervals = tmp;
            new_active_intervals.clear(false);
            index_0 = index;
            pt_0.setCoords(pt);
        }
        this.m_shape.removeUserIndex(node1);
        this.m_shape.removeUserIndex(node2);
    }

    void resolveOverlaps_(boolean b_axis_x, double clip_value) {
        Point2D pt = new Point2D();
        AttributeStreamOfInt32 sorted_vertices = new AttributeStreamOfInt32(0);
        sorted_vertices.reserve(100);
        int sorted_index = this.m_shape.createUserIndex();
        int nvert = this.m_vertices_on_extent.size();
        for (int ivert = 0; ivert < nvert; ++ivert) {
            int vertex = this.m_vertices_on_extent.get(ivert);
            if (vertex == -1) continue;
            int next_vertex = this.m_shape.getNextVertex(vertex);
            this.m_shape.getXY(vertex, pt);
            if (!(b_axis_x ? pt.y == clip_value : pt.x == clip_value)) continue;
            this.m_shape.getXY(next_vertex, pt);
            if (!(b_axis_x ? pt.y == clip_value : pt.x == clip_value)) continue;
            assert (this.m_shape.getUserIndex(next_vertex, this.m_vertices_on_extent_index) != -1);
            if (this.m_shape.getUserIndex(vertex, sorted_index) != -2) {
                sorted_vertices.add(vertex);
                this.m_shape.setUserIndex(vertex, sorted_index, -2);
            }
            if (this.m_shape.getUserIndex(next_vertex, sorted_index) == -2) continue;
            sorted_vertices.add(next_vertex);
            this.m_shape.setUserIndex(next_vertex, sorted_index, -2);
        }
        if (sorted_vertices.size() == 0) {
            this.m_shape.removeUserIndex(sorted_index);
            return;
        }
        sorted_vertices.Sort(0, sorted_vertices.size(), new ClipperVertexComparer(this));
        int n = sorted_vertices.size();
        for (int index = 0; index < n; ++index) {
            int vert = sorted_vertices.get(index);
            this.m_shape.setUserIndex(vert, sorted_index, index);
        }
        Point2D pt_tmp = new Point2D();
        Point2D pt_0 = new Point2D();
        pt_0.setNaN();
        int index_0 = -1;
        int n2 = sorted_vertices.size();
        for (int index = 0; index < n2; ++index) {
            int vert = sorted_vertices.get(index);
            if (vert == -1) continue;
            this.m_shape.getXY(vert, pt);
            if (pt.isEqual(pt_0)) continue;
            if (index_0 != -1) {
                boolean b_overlap_resolved;
                block3: do {
                    b_overlap_resolved = false;
                    int index_to = index - index_0 > 1 ? index - 1 : index;
                    for (int i = index_0; i < index_to; ++i) {
                        int v = sorted_vertices.get(i);
                        if (v == -1) continue;
                        int nextv = -1;
                        int nv = this.m_shape.getNextVertex(v);
                        if (this.compareVertices_(v, nv) < 0) {
                            this.m_shape.getXY(nv, pt_tmp);
                            if (b_axis_x ? pt_tmp.y == clip_value : pt_tmp.x == clip_value) {
                                nextv = nv;
                            }
                        }
                        int prevv = -1;
                        int pv = this.m_shape.getPrevVertex(v);
                        if (this.compareVertices_(v, pv) < 0) {
                            this.m_shape.getXY(pv, pt_tmp);
                            if (b_axis_x ? pt_tmp.y == clip_value : pt_tmp.x == clip_value) {
                                prevv = pv;
                            }
                        }
                        if (nextv != -1 && prevv != -1) {
                            this.beforeRemoveVertex_(v, sorted_vertices, sorted_index);
                            this.m_shape.removeVertex(v, false);
                            this.beforeRemoveVertex_(nextv, sorted_vertices, sorted_index);
                            this.m_shape.removeVertex(nextv, false);
                            b_overlap_resolved = true;
                            continue;
                        }
                        if (nextv == -1 && prevv == -1) continue;
                        for (int j = i + 1; j < index; ++j) {
                            int v_1 = sorted_vertices.get(j);
                            if (v_1 == -1) continue;
                            int nv1 = this.m_shape.getNextVertex(v_1);
                            int nextv1 = -1;
                            if (this.compareVertices_(v_1, nv1) < 0) {
                                this.m_shape.getXY(nv1, pt_tmp);
                                if (b_axis_x ? pt_tmp.y == clip_value : pt_tmp.x == clip_value) {
                                    nextv1 = nv1;
                                }
                            }
                            int pv1 = this.m_shape.getPrevVertex(v_1);
                            int prevv_1 = -1;
                            if (this.compareVertices_(v_1, pv1) < 0) {
                                this.m_shape.getXY(pv1, pt_tmp);
                                if (b_axis_x ? pt_tmp.y == clip_value : pt_tmp.x == clip_value) {
                                    prevv_1 = pv1;
                                }
                            }
                            if (nextv1 != -1 && prevv_1 != -1) {
                                this.beforeRemoveVertex_(v_1, sorted_vertices, sorted_index);
                                this.m_shape.removeVertex(v_1, false);
                                this.beforeRemoveVertex_(nextv1, sorted_vertices, sorted_index);
                                this.m_shape.removeVertex(nextv1, false);
                                b_overlap_resolved = true;
                                break;
                            }
                            if (nextv != -1 && prevv_1 != -1) {
                                this.removeOverlap_(sorted_vertices, v, nextv, v_1, prevv_1, sorted_index);
                                b_overlap_resolved = true;
                                break;
                            }
                            if (prevv == -1 || nextv1 == -1) continue;
                            this.removeOverlap_(sorted_vertices, v_1, nextv1, v, prevv, sorted_index);
                            b_overlap_resolved = true;
                            break;
                        }
                        if (b_overlap_resolved) continue block3;
                    }
                } while (b_overlap_resolved);
            }
            index_0 = index;
            pt_0.setCoords(pt);
        }
        this.m_shape.removeUserIndex(sorted_index);
    }

    void beforeRemoveVertex_(int v_1, AttributeStreamOfInt32 sorted_vertices, int sorted_index) {
        int first;
        int ind = this.m_shape.getUserIndex(v_1, sorted_index);
        sorted_vertices.set(ind, -1);
        ind = this.m_shape.getUserIndex(v_1, this.m_vertices_on_extent_index);
        this.m_vertices_on_extent.set(ind, -1);
        int path = this.m_shape.getPathFromVertex(v_1);
        if (path != -1 && (first = this.m_shape.getFirstVertex(path)) == v_1) {
            this.m_shape.setFirstVertex_(path, -1);
            this.m_shape.setLastVertex_(path, -1);
        }
    }

    void removeOverlap_(AttributeStreamOfInt32 sorted_vertices, int v, int nextv, int v_1, int prevv_1, int sorted_index) {
        assert (this.m_shape.isEqualXY(v, v_1));
        assert (this.m_shape.isEqualXY(nextv, prevv_1));
        assert (this.m_shape.getNextVertex(v) == nextv);
        assert (this.m_shape.getNextVertex(prevv_1) == v_1);
        this.m_shape.setNextVertex_(v, v_1);
        this.m_shape.setPrevVertex_(v_1, v);
        this.m_shape.setPrevVertex_(nextv, prevv_1);
        this.m_shape.setNextVertex_(prevv_1, nextv);
        this.beforeRemoveVertex_(v_1, sorted_vertices, sorted_index);
        this.m_shape.removeVertexInternal_(v_1, false);
        this.beforeRemoveVertex_(prevv_1, sorted_vertices, sorted_index);
        this.m_shape.removeVertexInternal_(prevv_1, true);
    }

    void fixPaths_() {
        int vertex;
        int nvert = this.m_vertices_on_extent.size();
        for (int ivert = 0; ivert < nvert; ++ivert) {
            int vertex2 = this.m_vertices_on_extent.get(ivert);
            if (vertex2 == -1) continue;
            this.m_shape.setPathToVertex_(vertex2, -1);
        }
        int path_count = 0;
        int geometry_size = 0;
        int path = this.m_shape.getFirstPath(this.m_geometry);
        while (path != -1) {
            int first = this.m_shape.getFirstVertex(path);
            if (first == -1 || path != this.m_shape.getPathFromVertex(first)) {
                int p = path;
                path = this.m_shape.getNextPath(path);
                this.m_shape.setFirstVertex_(p, -1);
                this.m_shape.removePathOnly_(p);
                continue;
            }
            assert (path == this.m_shape.getPathFromVertex(first));
            vertex = first;
            int path_size = 0;
            do {
                this.m_shape.setPathToVertex_(vertex, path);
                ++path_size;
            } while ((vertex = this.m_shape.getNextVertex(vertex)) != first);
            if (path_size <= 2) {
                int ind = this.m_shape.getUserIndex(first, this.m_vertices_on_extent_index);
                this.m_vertices_on_extent.set(ind, -1);
                int nv = this.m_shape.removeVertex(first, false);
                if (path_size == 2) {
                    ind = this.m_shape.getUserIndex(nv, this.m_vertices_on_extent_index);
                    this.m_vertices_on_extent.set(ind, -1);
                    this.m_shape.removeVertex(nv, false);
                }
                int p = path;
                path = this.m_shape.getNextPath(path);
                this.m_shape.setFirstVertex_(p, -1);
                this.m_shape.removePathOnly_(p);
                continue;
            }
            this.m_shape.setRingAreaValid_(path, false);
            this.m_shape.setLastVertex_(path, this.m_shape.getPrevVertex(first));
            this.m_shape.setPathSize_(path, path_size);
            geometry_size += path_size;
            ++path_count;
            path = this.m_shape.getNextPath(path);
        }
        int nvert2 = this.m_vertices_on_extent.size();
        for (int ivert = 0; ivert < nvert2; ++ivert) {
            int path2;
            vertex = this.m_vertices_on_extent.get(ivert);
            if (vertex == -1 || (path2 = this.m_shape.getPathFromVertex(vertex)) != -1) continue;
            path2 = this.m_shape.insertPath(this.m_geometry, -1);
            int path_size = 0;
            int first = vertex;
            do {
                this.m_shape.setPathToVertex_(vertex, path2);
                ++path_size;
            } while ((vertex = this.m_shape.getNextVertex(vertex)) != first);
            if (path_size <= 2) {
                int ind = this.m_shape.getUserIndex(first, this.m_vertices_on_extent_index);
                this.m_vertices_on_extent.set(ind, -1);
                int nv = this.m_shape.removeVertex(first, false);
                if (path_size == 2) {
                    ind = this.m_shape.getUserIndex(nv, this.m_vertices_on_extent_index);
                    if (ind >= 0) {
                        this.m_vertices_on_extent.set(ind, -1);
                    }
                    this.m_shape.removeVertex(nv, false);
                }
                int p = path2;
                path2 = this.m_shape.getNextPath(path2);
                this.m_shape.setFirstVertex_(p, -1);
                this.m_shape.removePathOnly_(p);
                continue;
            }
            this.m_shape.setClosedPath(path2, true);
            this.m_shape.setPathSize_(path2, path_size);
            this.m_shape.setFirstVertex_(path2, first);
            this.m_shape.setLastVertex_(path2, this.m_shape.getPrevVertex(first));
            this.m_shape.setRingAreaValid_(path2, false);
            geometry_size += path_size;
            ++path_count;
        }
        this.m_shape.setGeometryPathCount_(this.m_geometry, path_count);
        this.m_shape.setGeometryVertexCount_(this.m_geometry, geometry_size);
        int total_point_count = 0;
        int geometry = this.m_shape.getFirstGeometry();
        while (geometry != -1) {
            total_point_count += this.m_shape.getPointCount(geometry);
            geometry = this.m_shape.getNextGeometry(geometry);
        }
        this.m_shape.setTotalPointCount_(total_point_count);
    }

    static Geometry clipMultiPath_(MultiPath multipath, Envelope2D extent, double tolerance, double densify_dist) {
        Clipper clipper = new Clipper(extent);
        return clipper.clipMultiPath2_(multipath, tolerance, densify_dist);
    }

    Clipper(Envelope2D extent) {
        this.m_extent = extent;
        this.m_shape = new EditShape();
        this.m_vertices_on_extent = new AttributeStreamOfInt32(0);
    }

    static Geometry clip(Geometry geometry, Envelope2D extent, double tolerance, double densify_dist) {
        RasterizedGeometry2D rgeom;
        if (geometry.isEmpty()) {
            return geometry;
        }
        if (extent.isEmpty()) {
            return geometry.createInstance();
        }
        int geomtype = geometry.getType().value();
        if (geomtype == Geometry.Type.Point.value()) {
            Point2D pt = ((Point)geometry).getXY();
            if (extent.contains(pt)) {
                return geometry;
            }
            return geometry.createInstance();
        }
        if (geomtype == Geometry.Type.Envelope.value()) {
            Envelope2D env = new Envelope2D();
            geometry.queryEnvelope2D(env);
            if (env.intersect(extent)) {
                Envelope result_env = new Envelope();
                geometry.copyTo(result_env);
                result_env.setEnvelope2D(env);
                return result_env;
            }
            return geometry.createInstance();
        }
        Envelope2D env_2D = new Envelope2D();
        geometry.queryLooseEnvelope2D(env_2D);
        if (extent.contains(env_2D)) {
            return geometry;
        }
        if (!extent.isIntersecting(env_2D)) {
            return geometry.createInstance();
        }
        MultiVertexGeometryImpl impl = (MultiVertexGeometryImpl)geometry._getImpl();
        GeometryAccelerators accel = impl._getAccelerators();
        if (accel != null && (rgeom = accel.getRasterizedGeometry()) != null) {
            RasterizedGeometry2D.HitType hit = rgeom.queryEnvelopeInGeometry(extent);
            if (hit == RasterizedGeometry2D.HitType.Inside) {
                if (geomtype != Geometry.Type.Polygon.value()) {
                    throw GeometryException.GeometryInternalError();
                }
                Polygon poly = new Polygon(geometry.getDescription());
                poly.addEnvelope(extent, false);
                return poly;
            }
            if (hit == RasterizedGeometry2D.HitType.Outside) {
                return geometry.createInstance();
            }
        }
        switch (geomtype) {
            case 550: {
                MultiPoint multi_point = (MultiPoint)geometry;
                MultiPoint multi_point_out = null;
                int npoints = multi_point.getPointCount();
                AttributeStreamOfDbl xy = (AttributeStreamOfDbl)((MultiPointImpl)multi_point._getImpl()).getAttributeStreamRef(0);
                int ipoints0 = 0;
                for (int ipoints = 0; ipoints < npoints; ++ipoints) {
                    Point2D pt = new Point2D();
                    xy.read(2 * ipoints, pt);
                    if (extent.contains(pt)) continue;
                    if (ipoints0 == 0) {
                        multi_point_out = (MultiPoint)multi_point.createInstance();
                    }
                    if (ipoints0 < ipoints) {
                        multi_point_out.add(multi_point, ipoints0, ipoints);
                    }
                    ipoints0 = ipoints + 1;
                }
                if (ipoints0 > 0) {
                    multi_point_out.add(multi_point, ipoints0, npoints);
                }
                if (ipoints0 == 0) {
                    return multi_point;
                }
                return multi_point_out;
            }
            case 1607: 
            case 1736: {
                return Clipper.clipMultiPath_((MultiPath)geometry, extent, tolerance, densify_dist);
            }
        }
        assert (false);
        throw GeometryException.GeometryInternalError();
    }

    int compareVertices_(int v_1, int v_2) {
        Point2D pt_1 = new Point2D();
        this.m_shape.getXY(v_1, pt_1);
        Point2D pt_2 = new Point2D();
        this.m_shape.getXY(v_2, pt_2);
        int res = pt_1.compare(pt_2);
        return res;
    }

    static final class ClipperVertexComparer
    extends AttributeStreamOfInt32.IntComparator {
        Clipper m_clipper;

        ClipperVertexComparer(Clipper clipper) {
            this.m_clipper = clipper;
        }

        @Override
        public int compare(int v1, int v2) {
            return this.m_clipper.compareVertices_(v1, v2);
        }
    }
}

