/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point3D;
import java.io.Serializable;

public final class Envelope3D
implements Serializable {
    private static final long serialVersionUID = 1L;
    public double xmin;
    public double ymin;
    public double zmin;
    public double xmax;
    public double ymax;
    public double zmax;

    public static Envelope3D construct(double _xmin, double _ymin, double _zmin, double _xmax, double _ymax, double _zmax) {
        Envelope3D env = new Envelope3D(_xmin, _ymin, _zmin, _xmax, _ymax, _zmax);
        return env;
    }

    public Envelope3D(double _xmin, double _ymin, double _zmin, double _xmax, double _ymax, double _zmax) {
        this.setCoords(_xmin, _ymin, _zmin, _xmax, _ymax, _zmax);
    }

    public Envelope3D() {
    }

    public Envelope3D(Envelope3D other) {
        this.setCoords(other);
    }

    public void setInfinite() {
        this.xmin = NumberUtils.negativeInf();
        this.xmax = NumberUtils.positiveInf();
        this.ymin = NumberUtils.negativeInf();
        this.ymax = NumberUtils.positiveInf();
        this.zmin = NumberUtils.negativeInf();
        this.zmax = NumberUtils.positiveInf();
    }

    public void setEmpty() {
        this.xmin = NumberUtils.NaN();
        this.ymin = NumberUtils.NaN();
        this.zmin = NumberUtils.NaN();
        this.xmax = 0.0;
        this.ymax = 0.0;
        this.zmax = 0.0;
    }

    public boolean isEmpty() {
        return NumberUtils.isNaN(this.xmin);
    }

    public void setEmptyZ() {
        this.zmin = NumberUtils.NaN();
    }

    public boolean isEmptyZ() {
        return NumberUtils.isNaN(this.zmin);
    }

    public boolean hasEmptyDimension() {
        return this.isEmpty() || this.isEmptyZ();
    }

    public void setCoords(double _xmin, double _ymin, double _zmin, double _xmax, double _ymax, double _zmax) {
        this.xmin = _xmin;
        this.ymin = _ymin;
        this.zmin = _zmin;
        this.xmax = _xmax;
        this.ymax = _ymax;
        this.zmax = _zmax;
        this.normalize();
    }

    public void setCoords(double _x, double _y, double _z) {
        this.xmin = _x;
        this.ymin = _y;
        this.zmin = _z;
        this.xmax = _x;
        this.ymax = _y;
        this.zmax = _z;
    }

    public void setCoords(Point3D center, double width, double height, double depth) {
        this.xmin = center.x - width * 0.5;
        this.xmax = this.xmin + width;
        this.ymin = center.y - height * 0.5;
        this.ymax = this.ymin + height;
        this.zmin = center.z - depth * 0.5;
        this.zmax = this.zmin + depth;
        this.normalize();
    }

    public void setCoords(Envelope3D envSrc) {
        this.setCoords(envSrc.xmin, envSrc.ymin, envSrc.zmin, envSrc.xmax, envSrc.ymax, envSrc.zmax);
    }

    public double getWidth() {
        return this.xmax - this.xmin;
    }

    public double getHeight() {
        return this.ymax - this.ymin;
    }

    public double getDepth() {
        return this.zmax - this.zmin;
    }

    public void move(Point3D vector) {
        this.xmin += vector.x;
        this.ymin += vector.y;
        this.zmin += vector.z;
        this.xmax += vector.x;
        this.ymax += vector.y;
        this.zmax += vector.z;
    }

    public void normalize() {
        if (this.isEmpty()) {
            return;
        }
        double min2 = Math.min(this.xmin, this.xmax);
        double max2 = Math.max(this.xmin, this.xmax);
        this.xmin = min2;
        this.xmax = max2;
        min2 = Math.min(this.ymin, this.ymax);
        max2 = Math.max(this.ymin, this.ymax);
        this.ymin = min2;
        this.ymax = max2;
        min2 = Math.min(this.zmin, this.zmax);
        max2 = Math.max(this.zmin, this.zmax);
        this.zmin = min2;
        this.zmax = max2;
    }

    public void copyTo(Envelope2D env) {
        env.xmin = this.xmin;
        env.ymin = this.ymin;
        env.xmax = this.xmax;
        env.ymax = this.ymax;
    }

    public void mergeNE(double x, double y, double z) {
        if (this.xmin > x) {
            this.xmin = x;
        } else if (this.xmax < x) {
            this.xmax = x;
        }
        if (this.ymin > y) {
            this.ymin = y;
        } else if (this.ymax < y) {
            this.ymax = y;
        }
        if (this.zmin != NumberUtils.NaN()) {
            if (this.zmin > z) {
                this.zmin = z;
            } else if (this.zmax < z) {
                this.zmax = z;
            }
        } else {
            this.zmin = z;
            this.zmax = z;
        }
    }

    public void merge(double x, double y, double z) {
        if (this.isEmpty()) {
            this.xmin = x;
            this.ymin = y;
            this.zmin = z;
            this.xmax = x;
            this.ymax = y;
            this.zmax = z;
        } else {
            this.mergeNE(x, y, z);
        }
    }

    public void merge(Point3D pt) {
        this.merge(pt.x, pt.y, pt.z);
    }

    public void merge(Envelope3D other) {
        if (other.isEmpty()) {
            return;
        }
        this.merge(other.xmin, other.ymin, other.zmin);
        this.merge(other.xmax, other.ymax, other.zmax);
    }

    public void merge(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.merge(x1, y1, z1);
        this.merge(x2, y2, z2);
    }

    public void inflate(double dx, double dy, double dz) {
        if (this.isEmpty()) {
            return;
        }
        this.xmin -= dx;
        this.xmax += dx;
        this.ymin -= dy;
        this.ymax += dy;
        this.zmin -= dz;
        this.zmax += dz;
        if (this.xmin > this.xmax || this.ymin > this.ymax || this.zmin > this.zmax) {
            this.setEmpty();
        }
    }

    public boolean isIntersecting(Envelope3D other) {
        return !this.isEmpty() && !other.isEmpty() && (this.xmin <= other.xmin ? this.xmax >= other.xmin : other.xmax >= this.xmin) && (this.ymin <= other.ymin ? this.ymax >= other.ymin : other.ymax >= this.ymin) && (this.zmin <= other.zmin ? this.zmax >= other.zmin : other.zmax >= this.zmin);
    }

    public boolean intersect(Envelope3D other) {
        boolean bIntersecting;
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        if (other.xmin > this.xmin) {
            this.xmin = other.xmin;
        }
        if (other.xmax < this.xmax) {
            this.xmax = other.xmax;
        }
        if (other.ymin > this.ymin) {
            this.ymin = other.ymin;
        }
        if (other.ymax < this.ymax) {
            this.ymax = other.ymax;
        }
        if (other.zmin > this.zmin) {
            this.zmin = other.zmin;
        }
        if (other.zmax < this.zmax) {
            this.zmax = other.zmax;
        }
        boolean bl = bIntersecting = this.xmin <= this.xmax && this.ymin <= this.ymax && this.zmin <= this.zmax;
        if (!bIntersecting) {
            this.setEmpty();
        }
        return bIntersecting;
    }

    public boolean contains(Envelope3D other) {
        return other.xmin >= this.xmin && other.xmax <= this.xmax && other.ymin >= this.ymin && other.ymax <= this.ymax && other.zmin >= this.zmin && other.zmax <= this.zmax;
    }

    public boolean equals(Object _other) {
        if (_other == this) {
            return true;
        }
        if (!(_other instanceof Envelope3D)) {
            return false;
        }
        Envelope3D other = (Envelope3D)_other;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        return this.xmin == other.xmin && this.ymin == other.ymin && this.zmin == other.zmin && this.xmax == other.xmax && this.ymax == other.ymax && this.zmax == other.zmax;
    }

    public void construct(Envelope1D xinterval, Envelope1D yinterval, Envelope1D zinterval) {
        if (xinterval.isEmpty() || yinterval.isEmpty()) {
            this.setEmpty();
            return;
        }
        this.xmin = xinterval.vmin;
        this.xmax = xinterval.vmax;
        this.ymin = yinterval.vmin;
        this.ymax = yinterval.vmax;
        this.zmin = zinterval.vmin;
        this.zmax = zinterval.vmax;
    }

    public void queryCorners(Point3D[] corners) {
        if (corners == null || corners.length < 8) {
            throw new IllegalArgumentException();
        }
        corners[0] = new Point3D(this.xmin, this.ymin, this.zmin);
        corners[1] = new Point3D(this.xmin, this.ymax, this.zmin);
        corners[2] = new Point3D(this.xmax, this.ymax, this.zmin);
        corners[3] = new Point3D(this.xmax, this.ymin, this.zmin);
        corners[4] = new Point3D(this.xmin, this.ymin, this.zmax);
        corners[5] = new Point3D(this.xmin, this.ymax, this.zmax);
        corners[6] = new Point3D(this.xmax, this.ymax, this.zmax);
        corners[7] = new Point3D(this.xmax, this.ymin, this.zmax);
    }

    public void setFromPoints(Point3D[] points) {
        if (points == null || points.length == 0) {
            this.setEmpty();
            return;
        }
        Point3D p = points[0];
        this.setCoords(p.x, p.y, p.z);
        for (int i = 1; i < points.length; ++i) {
            Point3D pt = points[i];
            this.mergeNE(pt.x, pt.y, pt.z);
        }
    }
}

