/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.EnvSrlzr;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope1D;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Envelope3D;
import com.esri.core.geometry.GenericGeometrySerializer;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.LnSrlzr;
import com.esri.core.geometry.MultiVertexGeometry;
import com.esri.core.geometry.OperatorExportToJson;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.PtSrlzr;
import com.esri.core.geometry.SizeOf;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class Geometry
implements Serializable {
    VertexDescription m_description = null;
    volatile int m_touchFlag = 0;

    Geometry() {
    }

    public abstract Type getType();

    public abstract int getDimension();

    public abstract long estimateMemorySize();

    protected static long estimateMemorySize(double[] attributes) {
        return attributes != null ? SizeOf.sizeOfDoubleArray(attributes.length) : 0L;
    }

    public VertexDescription getDescription() {
        return this.m_description;
    }

    public void assignVertexDescription(VertexDescription src) {
        this._touch();
        if (src == this.m_description) {
            return;
        }
        this._assignVertexDescriptionImpl(src);
    }

    protected abstract void _assignVertexDescriptionImpl(VertexDescription var1);

    public void mergeVertexDescription(VertexDescription src) {
        this._touch();
        if (src == this.m_description) {
            return;
        }
        VertexDescription newdescription = VertexDescriptionDesignerImpl.getMergedVertexDescription(this.m_description, src);
        if (newdescription == this.m_description) {
            return;
        }
        this._assignVertexDescriptionImpl(newdescription);
    }

    public boolean hasAttribute(int semantics) {
        return this.getDescription().hasAttribute(semantics);
    }

    public void addAttribute(int semantics) {
        this._touch();
        if (this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescription newvd = VertexDescriptionDesignerImpl.getMergedVertexDescription(this.m_description, semantics);
        this._assignVertexDescriptionImpl(newvd);
    }

    public void dropAttribute(int semantics) {
        this._touch();
        if (!this.m_description.hasAttribute(semantics)) {
            return;
        }
        VertexDescription newvd = VertexDescriptionDesignerImpl.removeSemanticsFromVertexDescription(this.m_description, semantics);
        this._assignVertexDescriptionImpl(newvd);
    }

    public void dropAllAttributes() {
        this.assignVertexDescription(VertexDescriptionDesignerImpl.getDefaultDescriptor2D());
    }

    public abstract Envelope1D queryInterval(int var1, int var2);

    public abstract void queryEnvelope(Envelope var1);

    public abstract void queryEnvelope2D(Envelope2D var1);

    abstract void queryEnvelope3D(Envelope3D var1);

    public void queryLooseEnvelope2D(Envelope2D env) {
        this.queryEnvelope2D(env);
    }

    void queryLooseEnvelope3D(Envelope3D env) {
        this.queryEnvelope3D(env);
    }

    public abstract boolean isEmpty();

    public abstract void setEmpty();

    public abstract void applyTransformation(Transformation2D var1);

    abstract void applyTransformation(Transformation3D var1);

    public abstract Geometry createInstance();

    public abstract void copyTo(Geometry var1);

    public double calculateArea2D() {
        return 0.0;
    }

    public double calculateLength2D() {
        return 0.0;
    }

    protected Object _getImpl() {
        throw new RuntimeException("invalid call");
    }

    void addZ() {
        this.addAttribute(1);
    }

    public boolean hasZ() {
        return this.hasAttribute(1);
    }

    public void addM() {
        this.addAttribute(2);
    }

    public boolean hasM() {
        return this.hasAttribute(2);
    }

    public void addID() {
        this.addAttribute(3);
    }

    public boolean hasID() {
        return this.hasAttribute(3);
    }

    public static int getDimensionFromType(int type2) {
        return ((type2 & 0xC0) >> 6) + 1 >> 1;
    }

    public static boolean isPoint(int type2) {
        return (type2 & 0x20) != 0;
    }

    public static boolean isLinear(int type2) {
        return (type2 & 0x40) != 0;
    }

    public static boolean isArea(int type2) {
        return (type2 & 0x80) != 0;
    }

    public static boolean isSegment(int type2) {
        return (type2 & 0x100) != 0;
    }

    public static boolean isMultiVertex(int type2) {
        return (type2 & 0x200) != 0;
    }

    public static boolean isMultiPath(int type2) {
        return (type2 & 0x400) != 0;
    }

    public Geometry copy() {
        Geometry geom = this.createInstance();
        this.copyTo(geom);
        return geom;
    }

    public abstract Geometry getBoundary();

    public abstract void replaceNaNs(int var1, double var2);

    static Geometry _clone(Geometry src) {
        Geometry geom = src.createInstance();
        src.copyTo(geom);
        return geom;
    }

    public int getStateFlag() {
        this.m_touchFlag &= Integer.MAX_VALUE;
        return this.m_touchFlag;
    }

    synchronized void _touch() {
        if (this.m_touchFlag >= 0) {
            this.m_touchFlag += -2147483647;
        }
    }

    Object writeReplace() throws ObjectStreamException {
        Type gt = this.getType();
        if (gt == Type.Point) {
            PtSrlzr pt = new PtSrlzr();
            pt.setGeometryByValue((Point)this);
            return pt;
        }
        if (gt == Type.Envelope) {
            EnvSrlzr e = new EnvSrlzr();
            e.setGeometryByValue((Envelope)this);
            return e;
        }
        if (gt == Type.Line) {
            LnSrlzr ln = new LnSrlzr();
            ln.setGeometryByValue((Line)this);
            return ln;
        }
        GenericGeometrySerializer geomSerializer = new GenericGeometrySerializer();
        geomSerializer.setGeometryByValue(this);
        return geomSerializer;
    }

    public String toString() {
        String snippet = OperatorExportToJson.local().execute(null, this);
        if (snippet.length() > 200) {
            return snippet.substring(0, 197) + "... (" + snippet.length() + " characters)";
        }
        return snippet;
    }

    public static int vertex_count(Geometry geom) {
        Type gt = geom.getType();
        if (Geometry.isMultiVertex(gt.value())) {
            return ((MultiVertexGeometry)geom).getPointCount();
        }
        if (geom.isEmpty()) {
            return 0;
        }
        if (gt == Type.Envelope) {
            return 4;
        }
        if (gt == Type.Point) {
            return 1;
        }
        if (Geometry.isSegment(gt.value())) {
            return 2;
        }
        throw new GeometryException("missing type");
    }

    public static enum GeometryAccelerationDegree {
        enumMild,
        enumMedium,
        enumHot;

    }

    public static enum Type {
        Unknown(0),
        Point(33),
        Line(322),
        Envelope(197),
        MultiPoint(550),
        Polyline(1607),
        Polygon(1736);

        private int enumValue;

        public int value() {
            return this.enumValue;
        }

        private Type(int val2) {
            this.enumValue = val2;
        }

        public static Type intToType(int geometryType) {
            Type[] v = Type.values();
            for (int i = 0; i < v.length; ++i) {
                if (v[i].value() != geometryType) continue;
                return v[i];
            }
            throw new IllegalArgumentException();
        }
    }

    public static interface GeometryType {
        public static final int Unknown = 0;
        public static final int Point = 33;
        public static final int Line = 322;
        public static final int Bezier = 323;
        public static final int EllipticArc = 324;
        public static final int Envelope = 197;
        public static final int MultiPoint = 550;
        public static final int Polyline = 1607;
        public static final int Polygon = 1736;
    }
}

