/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.StridedIndexTypeCollection;

final class Treap {
    private int m_defaultTreap = Treap.nullNode();
    private int m_random = 124234251;
    private Comparator m_comparator = null;
    private StridedIndexTypeCollection m_treapData = new StridedIndexTypeCollection(7);
    private int m_touchFlag = 0;
    private boolean m_b_balancing = true;

    public void setComparator(Comparator comparator) {
        this.m_comparator = comparator;
    }

    public Comparator getComparator() {
        return this.m_comparator;
    }

    public void disableBalancing() {
        this.m_b_balancing = false;
    }

    public void setCapacity(int capacity) {
        this.m_treapData.setCapacity(capacity);
    }

    public int createTreap(int treap_data) {
        int treap = this.m_treapData.newElement();
        this.setSize_(0, treap);
        this.setTreapData_(treap_data, treap);
        return treap;
    }

    public void deleteTreap(int treap) {
        this.m_treapData.deleteElement(treap);
    }

    public int addElement(int element, int treap) {
        int treap_;
        if (treap == -1) {
            if (this.m_defaultTreap == Treap.nullNode()) {
                this.m_defaultTreap = this.createTreap(-1);
            }
            treap_ = this.m_defaultTreap;
        } else {
            treap_ = treap;
        }
        return this.addElement_(element, 0, treap_);
    }

    public int addUniqueElement(int element, int treap) {
        int treap_;
        if (treap == -1) {
            if (this.m_defaultTreap == Treap.nullNode()) {
                this.m_defaultTreap = this.createTreap(-1);
            }
            treap_ = this.m_defaultTreap;
        } else {
            treap_ = treap;
        }
        return this.addElement_(element, 1, treap_);
    }

    public int addBiggestElement(int element, int treap) {
        int treap_;
        if (treap == -1) {
            if (this.m_defaultTreap == Treap.nullNode()) {
                this.m_defaultTreap = this.createTreap(-1);
            }
            treap_ = this.m_defaultTreap;
        } else {
            treap_ = treap;
        }
        if (this.getRoot_(treap_) == Treap.nullNode()) {
            int newNode = this.newNode_(element);
            this.setRoot_(newNode, treap_);
            this.addToList_(-1, newNode, treap_);
            return newNode;
        }
        int cur = this.getLast_(treap_);
        int newNode = this.newNode_(element);
        this.setRight_(cur, newNode);
        this.setParent_(newNode, cur);
        assert (this.m_b_balancing);
        this.bubbleUp_(newNode);
        if (this.getParent(newNode) == Treap.nullNode()) {
            this.setRoot_(newNode, treap_);
        }
        this.addToList_(-1, newNode, treap_);
        return newNode;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int addElementAtPosition(int prevNode, int nextNode, int element, boolean bUnique, boolean bCallCompare, int treap) {
        int cur;
        int cmp;
        boolean bNext;
        int cmpPrev;
        int cmpNext;
        int treap_ = treap;
        if (treap_ == -1) {
            if (this.m_defaultTreap == Treap.nullNode()) {
                this.m_defaultTreap = this.createTreap(-1);
            }
            treap_ = this.m_defaultTreap;
        }
        if (this.getRoot_(treap_) == Treap.nullNode()) {
            assert (nextNode == Treap.nullNode() && prevNode == Treap.nullNode());
            int root = this.newNode_(element);
            this.setRoot_(root, treap_);
            this.addToList_(-1, root, treap_);
            return root;
        }
        if (bCallCompare) {
            int n = cmpNext = nextNode != Treap.nullNode() ? this.m_comparator.compare(this, element, nextNode) : -1;
            assert (cmpNext <= 0);
            cmpPrev = prevNode != Treap.nullNode() ? this.m_comparator.compare(this, element, prevNode) : 1;
        } else {
            cmpNext = -1;
            cmpPrev = 1;
        }
        if (bUnique && (cmpNext == 0 || cmpPrev == 0)) {
            this.m_comparator.onAddUniqueElementFailedImpl_(element);
            int cur2 = cmpNext == 0 ? nextNode : prevNode;
            this.setDuplicateElement_(cur2, treap_);
            return -1;
        }
        if (nextNode != Treap.nullNode() && prevNode != Treap.nullNode()) {
            bNext = this.m_random > NumberUtils.nextRand(this.m_random) >> 1;
        } else {
            boolean bl = bNext = nextNode != Treap.nullNode();
        }
        if (bNext) {
            cmp = cmpNext;
            cur = nextNode;
        } else {
            cmp = cmpPrev;
            cur = prevNode;
        }
        int newNode = -1;
        int before = -1;
        boolean b_first = true;
        while (true) {
            block19: {
                if (cmp < 0) {
                    int left = this.getLeft(cur);
                    if (left != Treap.nullNode()) {
                        cur = left;
                        break block19;
                    } else {
                        before = cur;
                        newNode = this.newNode_(element);
                        this.setLeft_(cur, newNode);
                        this.setParent_(newNode, cur);
                        break;
                    }
                }
                int right = this.getRight(cur);
                if (right != Treap.nullNode()) {
                    cur = right;
                } else {
                    before = this.getNext(cur);
                    newNode = this.newNode_(element);
                    this.setRight_(cur, newNode);
                    this.setParent_(newNode, cur);
                    break;
                }
            }
            if (!b_first) continue;
            cmp *= -1;
            b_first = false;
        }
        this.bubbleUp_(newNode);
        if (this.getParent(newNode) == Treap.nullNode()) {
            this.setRoot_(newNode, treap_);
        }
        this.addToList_(before, newNode, treap_);
        return newNode;
    }

    public int getDuplicateElement(int treap) {
        if (treap == -1) {
            return this.getDuplicateElement_(this.m_defaultTreap);
        }
        return this.getDuplicateElement_(treap);
    }

    public void deleteNode(int treap_node_index, int treap) {
        this.touch_();
        if (this.m_comparator != null) {
            this.m_comparator.onDeleteImpl_(this, treap_node_index);
        }
        int treap_ = treap == -1 ? this.m_defaultTreap : treap;
        if (!this.m_b_balancing) {
            this.unbalancedDelete_(treap_node_index, treap_);
        } else {
            this.deleteNode_(treap_node_index, treap_);
        }
    }

    public int search(int data, int treap) {
        int cur = this.getRoot(treap);
        while (cur != Treap.nullNode()) {
            int res = this.m_comparator.compare(this, data, cur);
            if (res == 0) {
                return cur;
            }
            if (res < 0) {
                cur = this.getLeft(cur);
                continue;
            }
            cur = this.getRight(cur);
        }
        this.m_comparator.onEndSearchImpl_(data);
        return Treap.nullNode();
    }

    public int searchLowerBound(MonikerComparator moniker, int treap) {
        int cur = this.getRoot(treap);
        int bound = -1;
        while (cur != Treap.nullNode()) {
            int res = moniker.compare(this, cur);
            if (res == 0) {
                return cur;
            }
            if (res < 0) {
                cur = this.getLeft(cur);
                continue;
            }
            bound = cur;
            cur = this.getRight(cur);
        }
        return bound;
    }

    public int searchUpperBound(MonikerComparator moniker, int treap) {
        int cur = this.getRoot(treap);
        int bound = -1;
        while (cur != Treap.nullNode()) {
            int res = moniker.compare(this, cur);
            if (res == 0) {
                return cur;
            }
            if (res < 0) {
                bound = cur;
                cur = this.getLeft(cur);
                continue;
            }
            cur = this.getRight(cur);
        }
        return bound;
    }

    public int getElement(int treap_node_index) {
        return this.m_treapData.getField(treap_node_index, 3);
    }

    public int getLeft(int treap_node_index) {
        return this.m_treapData.getField(treap_node_index, 0);
    }

    public int getRight(int treap_node_index) {
        return this.m_treapData.getField(treap_node_index, 1);
    }

    public int getParent(int treap_node_index) {
        return this.m_treapData.getField(treap_node_index, 2);
    }

    public int getNext(int treap_node_index) {
        return this.m_treapData.getField(treap_node_index, 6);
    }

    public int getPrev(int treap_node_index) {
        return this.m_treapData.getField(treap_node_index, 5);
    }

    public int getFirst(int treap) {
        if (treap == -1) {
            return this.getFirst_(this.m_defaultTreap);
        }
        return this.getFirst_(treap);
    }

    public int getLast(int treap) {
        if (treap == -1) {
            return this.getLast_(this.m_defaultTreap);
        }
        return this.getLast_(treap);
    }

    public int getTreapData(int treap) {
        if (treap == -1) {
            return this.getTreapData_(this.m_defaultTreap);
        }
        return this.getTreapData_(treap);
    }

    public void setElement(int treap_node_index, int newElement) {
        if (this.m_comparator != null) {
            this.m_comparator.onSetImpl_(this, treap_node_index);
        }
        this.setElement_(treap_node_index, newElement);
    }

    public int getRoot(int treap) {
        if (treap == -1) {
            return this.getRoot_(this.m_defaultTreap);
        }
        return this.getRoot_(treap);
    }

    public static int nullNode() {
        return -1;
    }

    public void clear() {
        this.m_treapData.deleteAll(false);
        this.m_defaultTreap = Treap.nullNode();
    }

    public int size(int treap) {
        if (treap == -1) {
            return this.getSize_(this.m_defaultTreap);
        }
        return this.getSize_(treap);
    }

    public int getMaxDepth(int treap) {
        return this.getMaxDepthHelper_(this.getRoot(treap));
    }

    public int getStateFlag() {
        this.m_touchFlag &= Integer.MAX_VALUE;
        return this.m_touchFlag;
    }

    private void touch_() {
        if (this.m_touchFlag >= 0) {
            this.m_touchFlag += -2147483647;
        }
    }

    private int getPriority_(int treap_node_index) {
        return this.m_treapData.getField(treap_node_index, 4);
    }

    private void bubbleDown_(int treap_node_index) {
        int left = this.getLeft(treap_node_index);
        int right = this.getRight(treap_node_index);
        int priority = this.getPriority_(treap_node_index);
        while (left != Treap.nullNode() || right != Treap.nullNode()) {
            int rcprior;
            int lcprior = left != Treap.nullNode() ? this.getPriority_(left) : NumberUtils.intMax();
            int minprior = Math.min(lcprior, rcprior = right != Treap.nullNode() ? this.getPriority_(right) : NumberUtils.intMax());
            if (priority <= minprior) {
                return;
            }
            if (lcprior <= rcprior) {
                this.rotateRight_(left);
            } else {
                this.rotateLeft_(treap_node_index);
            }
            left = this.getLeft(treap_node_index);
            right = this.getRight(treap_node_index);
        }
    }

    private void bubbleUp_(int node) {
        if (!this.m_b_balancing) {
            return;
        }
        int priority = this.getPriority_(node);
        int parent = this.getParent(node);
        while (parent != Treap.nullNode() && this.getPriority_(parent) > priority) {
            if (this.getLeft(parent) == node) {
                this.rotateRight_(node);
            } else {
                this.rotateLeft_(parent);
            }
            parent = this.getParent(node);
        }
    }

    private void rotateLeft_(int treap_node_index) {
        int px = treap_node_index;
        int py = this.getRight(treap_node_index);
        this.setParent_(py, this.getParent(px));
        this.setParent_(px, py);
        int ptemp = this.getLeft(py);
        this.setRight_(px, ptemp);
        if (ptemp != Treap.nullNode()) {
            this.setParent_(ptemp, px);
        }
        this.setLeft_(py, px);
        ptemp = this.getParent(py);
        if (ptemp != Treap.nullNode()) {
            if (this.getLeft(ptemp) == px) {
                this.setLeft_(ptemp, py);
            } else {
                assert (this.getRight(ptemp) == px);
                this.setRight_(ptemp, py);
            }
        }
    }

    private void rotateRight_(int treap_node_index) {
        int py = this.getParent(treap_node_index);
        int px = treap_node_index;
        this.setParent_(px, this.getParent(py));
        this.setParent_(py, px);
        int ptemp = this.getRight(px);
        this.setLeft_(py, ptemp);
        if (ptemp != Treap.nullNode()) {
            this.setParent_(ptemp, py);
        }
        this.setRight_(px, py);
        ptemp = this.getParent(px);
        if (ptemp != Treap.nullNode()) {
            if (this.getLeft(ptemp) == py) {
                this.setLeft_(ptemp, px);
            } else {
                assert (this.getRight(ptemp) == py);
                this.setRight_(ptemp, px);
            }
        }
    }

    private void setParent_(int treap_node_index, int new_parent) {
        this.m_treapData.setField(treap_node_index, 2, new_parent);
    }

    private void setLeft_(int treap_node_index, int new_left) {
        this.m_treapData.setField(treap_node_index, 0, new_left);
    }

    private void setRight_(int treap_node_index, int new_right) {
        this.m_treapData.setField(treap_node_index, 1, new_right);
    }

    private void setPriority_(int treap_node_index, int new_priority) {
        this.m_treapData.setField(treap_node_index, 4, new_priority);
    }

    private void setPrev_(int treap_node_index, int prev) {
        assert (prev != treap_node_index);
        this.m_treapData.setField(treap_node_index, 5, prev);
    }

    private void setNext_(int treap_node_index, int next2) {
        assert (next2 != treap_node_index);
        this.m_treapData.setField(treap_node_index, 6, next2);
    }

    private void setRoot_(int root, int treap) {
        this.m_treapData.setField(treap, 0, root);
    }

    private void setFirst_(int first, int treap) {
        this.m_treapData.setField(treap, 1, first);
    }

    private void setLast_(int last, int treap) {
        this.m_treapData.setField(treap, 2, last);
    }

    private void setDuplicateElement_(int duplicate_element, int treap) {
        this.m_treapData.setField(treap, 3, duplicate_element);
    }

    private void setSize_(int size, int treap) {
        this.m_treapData.setField(treap, 4, size);
    }

    private void setTreapData_(int treap_data, int treap) {
        this.m_treapData.setField(treap, 5, treap_data);
    }

    private int getRoot_(int treap) {
        if (treap == -1) {
            return Treap.nullNode();
        }
        return this.m_treapData.getField(treap, 0);
    }

    private int getFirst_(int treap) {
        if (treap == -1) {
            return Treap.nullNode();
        }
        return this.m_treapData.getField(treap, 1);
    }

    private int getLast_(int treap) {
        if (treap == -1) {
            return Treap.nullNode();
        }
        return this.m_treapData.getField(treap, 2);
    }

    private int getDuplicateElement_(int treap) {
        if (treap == -1) {
            return Treap.nullNode();
        }
        return this.m_treapData.getField(treap, 3);
    }

    private int getSize_(int treap) {
        if (treap == -1) {
            return 0;
        }
        return this.m_treapData.getField(treap, 4);
    }

    private int getTreapData_(int treap) {
        return this.m_treapData.getField(treap, 5);
    }

    private int newNode_(int element) {
        this.touch_();
        int newNode = this.m_treapData.newElement();
        this.setPriority_(newNode, this.generatePriority_());
        this.setElement_(newNode, element);
        return newNode;
    }

    private void freeNode_(int treap_node_index, int treap) {
        if (treap_node_index == Treap.nullNode()) {
            return;
        }
        this.m_treapData.deleteElement(treap_node_index);
    }

    private int generatePriority_() {
        this.m_random = NumberUtils.nextRand(this.m_random);
        return this.m_random & NumberUtils.intMax() >> 1;
    }

    private int getMaxDepthHelper_(int node) {
        if (node == Treap.nullNode()) {
            return 0;
        }
        return 1 + Math.max(this.getMaxDepthHelper_(this.getLeft(node)), this.getMaxDepthHelper_(this.getRight(node)));
    }

    private int addElement_(int element, int kind, int treap) {
        int before;
        int newNode;
        block6: {
            if (this.getRoot_(treap) == Treap.nullNode()) {
                int newNode2 = this.newNode_(element);
                this.setRoot_(newNode2, treap);
                this.addToList_(-1, newNode2, treap);
                return newNode2;
            }
            int cur = this.getRoot_(treap);
            newNode = -1;
            before = -1;
            while (true) {
                int cmp;
                int n = cmp = kind == -1 ? 1 : this.m_comparator.compare(this, element, cur);
                if (cmp < 0) {
                    int left = this.getLeft(cur);
                    if (left != Treap.nullNode()) {
                        cur = left;
                        continue;
                    }
                    before = cur;
                    newNode = this.newNode_(element);
                    this.setLeft_(cur, newNode);
                    this.setParent_(newNode, cur);
                    break block6;
                }
                if (kind == 1 && cmp == 0) {
                    this.m_comparator.onAddUniqueElementFailedImpl_(element);
                    this.setDuplicateElement_(cur, treap);
                    return -1;
                }
                int right = this.getRight(cur);
                if (right == Treap.nullNode()) break;
                cur = right;
            }
            before = this.getNext(cur);
            newNode = this.newNode_(element);
            this.setRight_(cur, newNode);
            this.setParent_(newNode, cur);
        }
        this.bubbleUp_(newNode);
        if (this.getParent(newNode) == Treap.nullNode()) {
            this.setRoot_(newNode, treap);
        }
        this.addToList_(before, newNode, treap);
        return newNode;
    }

    private void addToList_(int before, int node, int treap) {
        int prev;
        assert (before != node);
        if (before != -1) {
            prev = this.getPrev(before);
            this.setPrev_(before, node);
        } else {
            prev = this.getLast_(treap);
        }
        this.setPrev_(node, prev);
        if (prev != -1) {
            this.setNext_(prev, node);
        }
        this.setNext_(node, before);
        if (before == this.getFirst_(treap)) {
            this.setFirst_(node, treap);
        }
        if (before == -1) {
            this.setLast_(node, treap);
        }
        this.setSize_(this.getSize_(treap) + 1, treap);
    }

    private void removeFromList_(int node, int treap) {
        int prev = this.getPrev(node);
        int next2 = this.getNext(node);
        if (prev != -1) {
            this.setNext_(prev, next2);
        } else {
            this.setFirst_(next2, treap);
        }
        if (next2 != -1) {
            this.setPrev_(next2, prev);
        } else {
            this.setLast_(prev, treap);
        }
        this.setSize_(this.getSize_(treap) - 1, treap);
    }

    private void unbalancedDelete_(int treap_node_index, int treap) {
        int child;
        assert (!this.m_b_balancing);
        this.removeFromList_(treap_node_index, treap);
        int left = this.getLeft(treap_node_index);
        int right = this.getRight(treap_node_index);
        int parent = this.getParent(treap_node_index);
        int x = treap_node_index;
        if (left != -1 && right != -1) {
            this.m_random = NumberUtils.nextRand(this.m_random);
            int R = this.m_random > NumberUtils.intMax() >> 1 ? this.getNext(treap_node_index) : this.getPrev(treap_node_index);
            assert (R != -1);
            boolean bFixMe = this.getParent(R) == treap_node_index;
            this.m_treapData.swapField(treap_node_index, R, 0);
            this.m_treapData.swapField(treap_node_index, R, 1);
            this.m_treapData.swapField(treap_node_index, R, 2);
            if (parent != -1) {
                if (this.getLeft(parent) == treap_node_index) {
                    this.setLeft_(parent, R);
                } else {
                    assert (this.getRight(parent) == treap_node_index);
                    this.setRight_(parent, R);
                }
            } else {
                this.setRoot_(R, treap);
            }
            if (bFixMe) {
                if (left == R) {
                    this.setLeft_(R, treap_node_index);
                    this.setParent_(right, R);
                } else if (right == R) {
                    this.setRight_(R, treap_node_index);
                    this.setParent_(left, R);
                }
                this.setParent_(treap_node_index, R);
                parent = R;
            } else {
                this.setParent_(left, R);
                this.setParent_(right, R);
                parent = this.getParent(treap_node_index);
                x = R;
            }
            assert (parent != -1);
            left = this.getLeft(treap_node_index);
            right = this.getRight(treap_node_index);
            if (left != -1) {
                this.setParent_(left, treap_node_index);
            }
            if (right != -1) {
                this.setParent_(right, treap_node_index);
            }
            assert (left == -1 || right == -1);
        }
        int n = child = left != -1 ? left : right;
        if (parent == -1) {
            this.setRoot_(child, treap);
        } else if (this.getLeft(parent) == x) {
            this.setLeft_(parent, child);
        } else {
            assert (this.getRight(parent) == x);
            this.setRight_(parent, child);
        }
        if (child != -1) {
            this.setParent_(child, parent);
        }
        this.freeNode_(treap_node_index, treap);
    }

    private void deleteNode_(int treap_node_index, int treap) {
        boolean isroot;
        assert (this.m_b_balancing);
        this.setPriority_(treap_node_index, NumberUtils.intMax());
        int prl = Treap.nullNode();
        int prr = Treap.nullNode();
        int root = this.getRoot_(treap);
        boolean bl = isroot = root == treap_node_index;
        if (isroot) {
            prl = this.getLeft(root);
            prr = this.getRight(root);
            if (prl == Treap.nullNode() && prr == Treap.nullNode()) {
                this.removeFromList_(root, treap);
                this.freeNode_(root, treap);
                this.setRoot_(Treap.nullNode(), treap);
                return;
            }
        }
        this.bubbleDown_(treap_node_index);
        int p = this.getParent(treap_node_index);
        if (p != Treap.nullNode()) {
            if (this.getLeft(p) == treap_node_index) {
                this.setLeft_(p, Treap.nullNode());
            } else {
                this.setRight_(p, Treap.nullNode());
            }
        }
        this.removeFromList_(treap_node_index, treap);
        this.freeNode_(treap_node_index, treap);
        if (isroot) {
            this.setRoot_(prl == Treap.nullNode() || this.getParent(prl) != Treap.nullNode() ? prr : prl, treap);
        }
        assert (this.getParent(this.getRoot(treap)) == Treap.nullNode());
    }

    private void setElement_(int treap_node_index, int newElement) {
        this.touch_();
        this.m_treapData.setField(treap_node_index, 3, newElement);
    }

    static abstract class MonikerComparator {
        MonikerComparator() {
        }

        abstract int compare(Treap var1, int var2);
    }

    static abstract class Comparator {
        private boolean m_b_notify_on_actions;

        Comparator() {
            this.m_b_notify_on_actions = false;
        }

        Comparator(boolean bNotifyOnActions) {
            this.m_b_notify_on_actions = bNotifyOnActions;
        }

        abstract int compare(Treap var1, int var2, int var3);

        void onDelete(int elm) {
        }

        void onSet(int elm) {
        }

        void onEndSearch(int elm) {
        }

        void onAddUniqueElementFailed(int elm) {
        }

        void onDeleteImpl_(Treap treap, int node) {
            if (this.m_b_notify_on_actions) {
                this.onDelete(treap.getElement(node));
            }
        }

        void onSetImpl_(Treap treap, int node) {
            if (this.m_b_notify_on_actions) {
                this.onSet(treap.getElement(node));
            }
        }

        void onAddUniqueElementFailedImpl_(int elm) {
            if (this.m_b_notify_on_actions) {
                this.onAddUniqueElementFailed(elm);
            }
        }

        void onEndSearchImpl_(int elm) {
            if (this.m_b_notify_on_actions) {
                this.onEndSearch(elm);
            }
        }
    }
}

