/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv.impl;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.json.DupDetector;

public final class SimpleTokenWriteContext
extends JsonStreamContext {
    protected final SimpleTokenWriteContext _parent;
    protected DupDetector _dups;
    protected SimpleTokenWriteContext _childToRecycle;
    protected String _currentName;
    protected Object _currentValue;
    protected boolean _gotFieldId;

    protected SimpleTokenWriteContext(int type2, SimpleTokenWriteContext parent, DupDetector dups, Object currentValue) {
        this._type = type2;
        this._parent = parent;
        this._dups = dups;
        this._index = -1;
        this._currentValue = currentValue;
    }

    private SimpleTokenWriteContext reset(int type2, Object currentValue) {
        this._type = type2;
        this._index = -1;
        this._currentName = null;
        this._gotFieldId = false;
        this._currentValue = currentValue;
        if (this._dups != null) {
            this._dups.reset();
        }
        return this;
    }

    public SimpleTokenWriteContext withDupDetector(DupDetector dups) {
        this._dups = dups;
        return this;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object v) {
        this._currentValue = v;
    }

    public static SimpleTokenWriteContext createRootContext(DupDetector dd) {
        return new SimpleTokenWriteContext(0, null, dd, null);
    }

    public SimpleTokenWriteContext createChildArrayContext(Object currentValue) {
        SimpleTokenWriteContext ctxt = this._childToRecycle;
        if (ctxt == null) {
            this._childToRecycle = ctxt = new SimpleTokenWriteContext(1, this, this._dups == null ? null : this._dups.child(), currentValue);
            return ctxt;
        }
        return ctxt.reset(1, currentValue);
    }

    public SimpleTokenWriteContext createChildObjectContext(Object currentValue) {
        SimpleTokenWriteContext ctxt = this._childToRecycle;
        if (ctxt == null) {
            this._childToRecycle = ctxt = new SimpleTokenWriteContext(2, this, this._dups == null ? null : this._dups.child(), currentValue);
            return ctxt;
        }
        return ctxt.reset(2, currentValue);
    }

    @Override
    public final SimpleTokenWriteContext getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    @Override
    public boolean hasCurrentName() {
        return this._gotFieldId;
    }

    public SimpleTokenWriteContext clearAndGetParent() {
        this._currentValue = null;
        return this._parent;
    }

    public DupDetector getDupDetector() {
        return this._dups;
    }

    public boolean writeFieldName(String name) throws JsonProcessingException {
        if (this._type != 2 || this._gotFieldId) {
            return false;
        }
        this._gotFieldId = true;
        this._currentName = name;
        if (this._dups != null) {
            this._checkDup(this._dups, name);
        }
        return true;
    }

    private final void _checkDup(DupDetector dd, String name) throws JsonProcessingException {
        if (dd.isDup(name)) {
            Object src = dd.getSource();
            throw new JsonGenerationException("Duplicate field '" + name + "'", src instanceof JsonGenerator ? (JsonGenerator)src : null);
        }
    }

    public boolean writeValue() {
        if (this._type == 2) {
            if (!this._gotFieldId) {
                return false;
            }
            this._gotFieldId = false;
        }
        ++this._index;
        return true;
    }
}

