/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv.impl;

import com.fasterxml.jackson.core.io.IOContext;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public final class UTF8Reader
extends Reader {
    private final IOContext _ioContext;
    private InputStream _inputSource;
    private final boolean _autoClose;
    private byte[] _inputBuffer;
    private int _inputPtr;
    private int _inputEnd;
    private int _surrogate = -1;
    private int _charCount = 0;
    private int _byteCount = 0;
    private int _decodeErrorOffset;
    private char[] _tmpBuffer = null;

    public UTF8Reader(IOContext ctxt, InputStream in, boolean autoClose, byte[] buf, int ptr, int len2) {
        super(in == null ? buf : (byte[])in);
        this._ioContext = ctxt;
        this._inputSource = in;
        this._inputBuffer = buf;
        this._inputPtr = ptr;
        this._inputEnd = ptr + len2;
        this._autoClose = autoClose;
    }

    public UTF8Reader(IOContext ctxt, byte[] buf, int ptr, int len2) {
        super(new Object());
        this._ioContext = ctxt;
        this._inputSource = null;
        this._inputBuffer = buf;
        this._inputPtr = ptr;
        this._inputEnd = ptr + len2;
        this._autoClose = true;
    }

    public UTF8Reader(IOContext ctxt, InputStream in, boolean autoClose) {
        super(in);
        this._ioContext = ctxt;
        this._inputSource = in;
        this._inputBuffer = ctxt.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._autoClose = autoClose;
    }

    protected final boolean canModifyBuffer() {
        return this._ioContext != null;
    }

    @Override
    public void close() throws IOException {
        InputStream in = this._inputSource;
        if (in != null) {
            this._inputSource = null;
            if (this._autoClose) {
                in.close();
            }
        }
        this.freeBuffers();
    }

    @Override
    public int read() throws IOException {
        if (this._tmpBuffer == null) {
            this._tmpBuffer = new char[1];
        }
        if (this.read(this._tmpBuffer, 0, 1) < 1) {
            return -1;
        }
        return this._tmpBuffer[0];
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(char[] cbuf, int start, int len) throws IOException {
        if (this._inputBuffer == null) {
            return -1;
        }
        len += start;
        outPtr = start;
        if (this._surrogate >= 0) {
            cbuf[outPtr++] = (char)this._surrogate;
            this._surrogate = -1;
        } else {
            if (this._decodeErrorOffset != 0) {
                this.reportDeferredInvalid();
            }
            if (!((left = this._inputEnd - this._inputPtr) >= 4 || left >= 1 && this._inputBuffer[this._inputPtr] >= 0 || this.loadMore(left))) {
                return -1;
            }
        }
        buf = this._inputBuffer;
        inPtr = this._inputPtr;
        inBufLen = this._inputEnd;
        block0: while (outPtr < len) {
            if ((c = buf[inPtr++]) < 0) ** GOTO lbl26
            cbuf[outPtr++] = (char)c;
            inMax = inBufLen - inPtr;
            outMax = len - outPtr;
            inEnd = inPtr + (inMax < outMax ? inMax : outMax);
            while (inPtr < inEnd) {
                if ((c = buf[inPtr++]) >= 0) {
                    cbuf[outPtr++] = (char)c;
                    continue;
                }
lbl26:
                // 3 sources

                if ((c & 224) == 192) {
                    c &= 31;
                    needed = 1;
                } else if ((c & 240) == 224) {
                    c &= 15;
                    needed = 2;
                } else if ((c & 248) == 240) {
                    c &= 15;
                    needed = 3;
                } else {
                    this.reportInvalidInitial(c & 255, outPtr - start);
                    --inPtr;
                    break block0;
                }
                if (inBufLen - inPtr < needed) {
                    --inPtr;
                    break block0;
                }
                d = buf[inPtr];
                if ((d & 192) != 128) {
                    this.reportInvalidOther(d & 255, outPtr - start, 2);
                    break block0;
                }
                ++inPtr;
                c = c << 6 | d & 63;
                if (needed > 1) {
                    d = buf[inPtr];
                    if ((d & 192) != 128) {
                        this.reportInvalidOther(d & 255, outPtr - start, 3);
                        break block0;
                    }
                    ++inPtr;
                    c = c << 6 | d & 63;
                    if (needed > 2) {
                        d = buf[inPtr];
                        if ((d & 192) != 128) {
                            this.reportInvalidOther(d & 255, outPtr - start, 4);
                            break block0;
                        }
                        ++inPtr;
                        c = c << 6 | d & 63;
                        cbuf[outPtr++] = (char)(55296 + ((c -= 65536) >> 10));
                        c = 56320 | c & 1023;
                        if (outPtr >= len) {
                            this._surrogate = c;
                            break block0;
                        }
                    }
                }
                cbuf[outPtr++] = (char)c;
                if (inPtr < inBufLen) continue block0;
                break block0;
            }
            break block0;
        }
        this._inputPtr = inPtr;
        len = outPtr - start;
        this._charCount += len;
        return len;
    }

    protected final InputStream getStream() {
        return this._inputSource;
    }

    protected final int readBytes() throws IOException {
        this._inputPtr = 0;
        this._inputEnd = 0;
        if (this._inputSource != null) {
            int count = this._inputSource.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (count > 0) {
                this._inputEnd = count;
            }
            return count;
        }
        return -1;
    }

    protected final int readBytesAt(int offset) throws IOException {
        if (this._inputSource != null) {
            int count = this._inputSource.read(this._inputBuffer, offset, this._inputBuffer.length - offset);
            if (count > 0) {
                this._inputEnd += count;
            }
            return count;
        }
        return -1;
    }

    public final void freeBuffers() {
        byte[] buf;
        if (this._ioContext != null && (buf = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(buf);
        }
    }

    private boolean loadMore(int available) throws IOException {
        int needed;
        byte c;
        this._byteCount += this._inputEnd - available;
        if (available > 0) {
            if (this._inputPtr > 0) {
                if (!this.canModifyBuffer()) {
                    throw new IllegalStateException("Need to move partially decoded character; buffer not modifiable");
                }
                for (int i = 0; i < available; ++i) {
                    this._inputBuffer[i] = this._inputBuffer[this._inputPtr + i];
                }
                this._inputPtr = 0;
                this._inputEnd = available;
            }
        } else {
            int count = this.readBytes();
            if (count < 1) {
                this.freeBuffers();
                if (count < 0) {
                    return false;
                }
                this.reportStrangeStream();
            }
        }
        if ((c = this._inputBuffer[this._inputPtr]) >= 0) {
            return true;
        }
        if ((c & 0xE0) == 192) {
            needed = 2;
        } else if ((c & 0xF0) == 224) {
            needed = 3;
        } else if ((c & 0xF8) == 240) {
            needed = 4;
        } else {
            return true;
        }
        while (this._inputPtr + needed > this._inputEnd) {
            int count = this.readBytesAt(this._inputEnd);
            if (count >= 1) continue;
            if (count < 0) {
                this.freeBuffers();
                this.reportUnexpectedEOF(this._inputEnd, needed);
            }
            this.reportStrangeStream();
        }
        return true;
    }

    protected void reportBounds(char[] cbuf, int start, int len2) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + start + "," + len2 + "), cbuf[" + cbuf.length + "]");
    }

    protected void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }

    protected void reportInvalidInitial(int mask, int outputDecoded) throws IOException {
        if (this._decodeErrorOffset == 0 && outputDecoded > 0) {
            this._decodeErrorOffset = 1;
            return;
        }
        int bytePos = this._byteCount + this._inputPtr - 1;
        int charPos = this._charCount + outputDecoded + 1;
        throw new CharConversionException(String.format("Invalid UTF-8 start byte 0x%s (at char #%d, byte #%d): check content encoding, does not look like UTF-8", Integer.toHexString(mask), charPos, bytePos));
    }

    protected void reportInvalidOther(int mask, int outputDecoded, int errorPosition) throws IOException {
        if (this._decodeErrorOffset == 0 && outputDecoded > 0) {
            this._decodeErrorOffset = errorPosition;
            return;
        }
        int bytePos = this._byteCount + this._inputPtr - 1;
        int charPos = this._charCount + outputDecoded + 1;
        throw new CharConversionException(String.format("Invalid UTF-8 middle byte 0x%s (at char #%d, byte #%d): check content encoding, does not look like UTF-8", Integer.toHexString(mask), charPos, bytePos));
    }

    protected void reportDeferredInvalid() throws IOException {
        int ch = this._inputBuffer[this._inputPtr] & 0xFF;
        if (this._decodeErrorOffset == 1) {
            this.reportInvalidInitial(ch, 0);
        } else {
            this.reportInvalidOther(ch, 0, this._decodeErrorOffset);
        }
    }

    protected void reportUnexpectedEOF(int gotBytes, int needed) throws IOException {
        int bytePos = this._byteCount + gotBytes;
        int charPos = this._charCount;
        throw new CharConversionException(String.format("Unexpected EOF in the middle of a multi-byte UTF-8 character: got %d, needed %d, at char #%d, byte #%d)", gotBytes, needed, charPos, bytePos));
    }
}

