/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.BigIntegerMath;
import com.google.uzaygezen.core.BitSetComparator;
import com.google.uzaygezen.core.BitSetMath;
import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.MathUtils;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;

public final class BitSetBackedBitVector
implements BitVector,
Cloneable {
    private final BitSet bitset;
    private final int size;

    public BitSetBackedBitVector(int nbits) {
        this(nbits, new BitSet(nbits));
    }

    private BitSetBackedBitVector(int size, BitSet bitset) {
        this.size = size;
        this.bitset = bitset;
    }

    private void checkSize(BitVector other) {
        if (other.size() != this.size()) {
            throw new IllegalArgumentException("Sizes are not equal. this:" + this.size + " other:" + other.size());
        }
    }

    private void checkIndex(int bitIndex) {
        if (bitIndex < 0 | bitIndex >= this.size) {
            throw new IndexOutOfBoundsException("BitIndex should be smaller than size : " + bitIndex);
        }
    }

    @Override
    public void and(BitVector o) {
        this.checkSize(o);
        this.bitset.and(BitSetBackedBitVector.toPotentiallySharedBitSet(o));
    }

    @Override
    public void andNot(BitVector o) {
        this.checkSize(o);
        this.bitset.andNot(BitSetBackedBitVector.toPotentiallySharedBitSet(o));
    }

    @Override
    public int cardinality() {
        return this.bitset.cardinality();
    }

    @Override
    public void clear() {
        this.bitset.clear();
    }

    @Override
    public void clear(int bitIndex) {
        this.checkIndex(bitIndex);
        this.bitset.clear(bitIndex);
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        this.bitset.clear(fromIndex, toIndex);
    }

    @Override
    public void copyFrom(BitVector from) {
        if (from.size() <= 64) {
            this.copyFrom(from.toExactLong());
        } else {
            this.bitset.clear();
            this.bitset.or(BitSetBackedBitVector.toPotentiallySharedBitSet(from));
        }
    }

    @Override
    public void flip(int bitIndex) {
        this.checkIndex(bitIndex);
        this.bitset.flip(bitIndex);
    }

    @Override
    public void flip(int fromIndex, int toIndex) {
        this.bitset.flip(fromIndex, toIndex);
    }

    @Override
    public boolean get(int bitIndex) {
        this.checkIndex(bitIndex);
        return this.bitset.get(bitIndex);
    }

    @Override
    public void grayCode() {
        BitSetMath.grayCode(this.bitset);
    }

    @Override
    public void grayCodeInverse() {
        BitSetMath.grayCodeInverse(this.bitset);
    }

    @Override
    public boolean increment() {
        int tsb = this.bitset.nextClearBit(0);
        if (tsb == this.size) {
            return false;
        }
        this.bitset.set(tsb);
        this.bitset.clear(0, tsb);
        return true;
    }

    @Override
    public boolean intersects(BitVector o) {
        this.checkSize(o);
        return this.bitset.intersects(BitSetBackedBitVector.toPotentiallySharedBitSet(o));
    }

    @Override
    public int length() {
        return this.bitset.length();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int nextClearBit(int fromIndex) {
        Preconditions.checkArgument(fromIndex >= 0);
        int ncb = this.bitset.nextClearBit(fromIndex);
        if (ncb >= this.size) {
            ncb = -1;
        }
        assert (-1 <= ncb & ncb < this.size);
        return ncb;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        return this.bitset.nextSetBit(fromIndex);
    }

    @Override
    public void or(BitVector o) {
        this.checkSize(o);
        this.bitset.or(BitSetBackedBitVector.toPotentiallySharedBitSet(o));
    }

    @Override
    public void rotate(int count) {
        BitSetMath.rotate(this.bitset, this.size, count);
    }

    @Override
    public void set(int bitIndex) {
        this.checkIndex(bitIndex);
        this.bitset.set(bitIndex);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        this.bitset.set(bitIndex, value);
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        this.bitset.set(fromIndex, toIndex);
    }

    @Override
    public void set(int fromIndex, int toIndex, boolean value) {
        this.bitset.set(fromIndex, toIndex, value);
    }

    @Override
    public void xor(BitVector o) {
        this.checkSize(o);
        this.bitset.xor(BitSetBackedBitVector.toPotentiallySharedBitSet(o));
    }

    public BitSet getBitset() {
        return this.bitset;
    }

    @Override
    public boolean isEmpty() {
        return this.bitset.isEmpty();
    }

    @Override
    public BitSetBackedBitVector clone() {
        return new BitSetBackedBitVector(this.size, (BitSet)this.bitset.clone());
    }

    @Override
    public int hashCode() {
        return this.size + 31 * this.bitset.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BitSetBackedBitVector) {
            BitSetBackedBitVector other = (BitSetBackedBitVector)obj;
            return this.size == other.size && this.bitset.equals(other.bitset);
        }
        if (obj instanceof BitVector) {
            BitVector other = (BitVector)obj;
            if (this.size <= 64) {
                return this.size == other.size() && this.toExactLong() == other.toExactLong();
            }
            return this.size == other.size() && this.bitset.equals(other.toBitSet());
        }
        return false;
    }

    @Override
    public BitSet toBitSet() {
        return (BitSet)this.bitset.clone();
    }

    public String toString() {
        return "size: " + this.size + " bitset: " + this.bitset;
    }

    @Override
    public long toLong() {
        long value = 0L;
        int i = this.bitset.nextSetBit(0);
        while (i != -1 & i < 64) {
            assert (i < this.size);
            value |= 1L << i;
            i = this.bitset.nextSetBit(i + 1);
        }
        return value;
    }

    @Override
    public void copyFrom(long value) {
        int lowestSetBit;
        int bitLength = 64 - Long.numberOfLeadingZeros(value);
        Preconditions.checkArgument(bitLength <= this.size, "value doesn't fit");
        this.bitset.clear();
        for (int i = lowestSetBit = Long.numberOfTrailingZeros(value); i < bitLength; ++i) {
            if ((value & 1L << i) == 0L) continue;
            this.bitset.set(i);
        }
    }

    @Override
    public int compareTo(BitVector o) {
        this.checkSize(o);
        return BitSetComparator.INSTANCE.compare(this.bitset, BitSetBackedBitVector.toPotentiallySharedBitSet(o));
    }

    @Override
    public void copyFrom(BitSet from) {
        Preconditions.checkArgument(from.length() <= this.size, "bit set is too large");
        this.bitset.clear();
        this.bitset.or(from);
    }

    @Override
    public void copyFromSection(BitVector src, int fromIndex) {
        Preconditions.checkArgument(fromIndex >= 0, "fromIndex must be non-negative");
        int srcSize = src.size();
        int toIndex = fromIndex + this.size;
        Preconditions.checkArgument(toIndex <= srcSize, "not enough bits in src");
        this.bitset.clear();
        int i = src.nextSetBit(fromIndex);
        while (i < toIndex && i != -1) {
            this.bitset.set(i - fromIndex);
            i = src.nextSetBit(i + 1);
        }
    }

    @Override
    public long toExactLong() {
        long value = 0L;
        int i = this.bitset.nextSetBit(0);
        while (i != -1) {
            assert (i < this.size);
            Preconditions.checkState(i < 64, "does not fit in long");
            value |= 1L << i;
            i = this.bitset.nextSetBit(i + 1);
        }
        return value;
    }

    private static BitSet toPotentiallySharedBitSet(BitVector bv) {
        if (bv instanceof BitSetBackedBitVector) {
            return ((BitSetBackedBitVector)bv).bitset;
        }
        return bv.toBitSet();
    }

    @Override
    public void smallerEvenAndGrayCode() {
        if (this.bitset.get(0)) {
            this.bitset.clear(0);
            this.grayCode();
        } else {
            int firstSetIndex = this.bitset.nextSetBit(1);
            if (firstSetIndex != -1) {
                this.bitset.clear(firstSetIndex);
                this.bitset.set(1, firstSetIndex, true);
                assert (!this.bitset.get(0));
                this.grayCode();
            }
        }
    }

    @Override
    public void grayCodeRank(BitVector mu, BitVector w) {
        int j;
        Preconditions.checkArgument(this.size() == mu.cardinality(), "r has the wrong size");
        Preconditions.checkArgument(mu.size() == w.size(), "mu/w size mismatch");
        this.clear();
        int pos = 0;
        int n = j = mu.size() == 0 ? -1 : mu.nextSetBit(0);
        while (j != -1) {
            if (w.get(j)) {
                this.bitset.set(pos);
            }
            ++pos;
            j = j == mu.size() - 1 ? -1 : mu.nextSetBit(j + 1);
        }
    }

    @Override
    public int lowestDifferentBit() {
        int value;
        if (this.bitset.isEmpty()) {
            value = 0;
        } else if (this.bitset.get(0)) {
            int tsb = this.bitset.nextClearBit(0);
            assert (tsb <= this.size) : "bitset=" + this.bitset;
            value = tsb == this.size ? 0 : tsb;
        } else {
            int tcb = this.bitset.nextSetBit(0);
            assert (0 < tcb & tcb < this.size);
            value = tcb;
        }
        assert (value == 0 || 0 < value & value < this.size);
        return value;
    }

    @Override
    public void grayCodeRankInverse(BitVector mu, BitVector known, BitVector r) {
        int k;
        Preconditions.checkArgument(r.size() == mu.cardinality(), "r.size()/mu.cardinality() mismatch");
        int muSize = mu.size();
        Preconditions.checkArgument(this.size == muSize, "i/mu size mismatch");
        Preconditions.checkArgument(!known.intersects(mu), "known and mu must not intersect");
        this.bitset.clear();
        int pos = 0;
        int highestFreeBitIndex = -1;
        int n = k = muSize == 0 ? -1 : mu.nextSetBit(0);
        while (k != -1) {
            highestFreeBitIndex = k;
            if (r.get(pos)) {
                this.bitset.set(k);
            }
            ++pos;
            k = k == muSize - 1 ? -1 : mu.nextSetBit(k + 1);
        }
        k = Math.max(highestFreeBitIndex, known.length());
        while (--k >= 0) {
            if (mu.get(k)) continue;
            assert (!this.bitset.get(k));
            if (!(known.get(k) ^ this.bitset.get(k + 1))) continue;
            this.bitset.set(k);
        }
    }

    @Override
    public void copySectionFrom(int offset, BitVector src) {
        int j;
        int srcSize;
        int toIndex;
        if (offset < 0 | (toIndex = offset + (srcSize = src.size())) > this.size) {
            throw new IndexOutOfBoundsException("invalid range: offset=" + offset + " src.size()=" + src.size());
        }
        this.bitset.clear(offset, toIndex);
        int n = j = srcSize == 0 ? -1 : src.nextSetBit(0);
        while (j != -1) {
            this.bitset.set(offset + j);
            j = j == srcSize - 1 ? -1 : src.nextSetBit(j + 1);
        }
    }

    @Override
    public long[] toLongArray() {
        int n;
        long[] array = this.bitset.toLongArray();
        if (array.length < (n = this.size + 63 >>> 6)) {
            return Arrays.copyOf(array, n);
        }
        assert (array.length == n);
        return array;
    }

    @Override
    public byte[] toBigEndianByteArray() {
        int n = MathUtils.bitCountToByteCount(this.size);
        byte[] littleEndian = this.bitset.toByteArray();
        assert (n >= littleEndian.length);
        byte[] a = Arrays.copyOf(littleEndian, n);
        ArrayUtils.reverse(a);
        return a;
    }

    @Override
    public BigInteger toBigInteger() {
        return new BigInteger(this.isEmpty() ? 0 : 1, this.toBigEndianByteArray());
    }

    @Override
    public void copyFrom(long[] array) {
        int len2 = this.size + 63 >>> 6;
        Preconditions.checkArgument(array.length == len2, "Length must be %s.", new Object[]{len2});
        if (this.size == 0) {
            return;
        }
        Preconditions.checkArgument(Long.numberOfLeadingZeros(array[len2 - 1]) >= (len2 << 6) - this.size, "Some bit positions are too high.");
        BitSet bs = BitSet.valueOf(array);
        this.bitset.clear();
        this.bitset.or(bs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFromBigEndian(byte[] array) {
        BitSet bs;
        int len2 = MathUtils.bitCountToByteCount(this.size);
        Preconditions.checkArgument(array.length == len2, "Length must be %s.", new Object[]{len2});
        if (len2 == 0) {
            return;
        }
        Preconditions.checkArgument(MathUtils.numberOfLeadingZeros(array[0]) >= (len2 << 3) - this.size, "Some bit positions are too high.");
        ArrayUtils.reverse(array);
        try {
            bs = BitSet.valueOf(array);
        }
        finally {
            ArrayUtils.reverse(array);
        }
        this.bitset.clear();
        this.bitset.or(bs);
    }

    @Override
    public boolean areAllLowestBitsClear(int bitCount) {
        Preconditions.checkArgument(0 <= bitCount & bitCount <= this.size, "bitCount is out of range");
        int firstSetBit = this.bitset.nextSetBit(0);
        return firstSetBit == -1 | firstSetBit >= bitCount;
    }

    @Override
    public void copyFrom(BigInteger s2) {
        byte[] array = BigIntegerMath.nonnegativeBigIntegerToBigEndianByteArrayForBitSize(s2, this.size);
        this.copyFromBigEndian(array);
    }
}

