/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.MathUtils;
import java.util.BitSet;

public class BitSetMath {
    private BitSetMath() {
    }

    public static int increment(BitSet i) {
        int tsb = i.nextClearBit(0);
        i.set(tsb);
        i.clear(0, tsb);
        return tsb;
    }

    public static void rotate(BitSet bs, int n, int count) {
        int gcd = MathUtils.gcd(n, count);
        if (gcd != 0) {
            if (gcd == n) {
                return;
            }
            int m3 = n / gcd;
            for (int i = 0; i < gcd; ++i) {
                boolean previous = bs.get(i);
                int jTimesCount = 0;
                for (int j = 1; j <= m3; ++j) {
                    boolean current;
                    int index = i - (jTimesCount += count) % n;
                    if (index < 0) {
                        index += n;
                    }
                    if (previous ^ (current = bs.get(index))) {
                        bs.set(index, previous);
                        previous = current;
                    }
                    assert (j < m3 ^ jTimesCount % n == 0);
                }
            }
        }
    }

    public static void extractBitRange(BitSet chi, int from, int to, BitSet r) {
        r.clear();
        int j = chi.nextSetBit(from);
        while (j < to & j != -1) {
            r.set(j - from);
            j = chi.nextSetBit(j + 1);
        }
    }

    public static void grayCode(BitSet i) {
        boolean oneBeyond = true;
        for (int j = i.length() - 2; j >= 0; --j) {
            boolean current = i.get(j);
            if (oneBeyond) {
                i.set(j, !current);
            }
            oneBeyond = current;
        }
    }

    public static void grayCodeInverse(BitSet i) {
        boolean oneBeyond = true;
        for (int j = i.length() - 2; j >= 0; --j) {
            if (oneBeyond) {
                oneBeyond = !i.get(j);
                i.set(j, oneBeyond);
                continue;
            }
            oneBeyond = i.get(j);
        }
    }

    public static void copy(BitSet from, BitSet to) {
        to.clear();
        to.or(from);
    }

    public static long littleEndianBitSetToNonNegativeLong(BitSet bs) {
        Preconditions.checkArgument(bs.length() < 64, "too many bits");
        long value = 0L;
        int i = bs.nextSetBit(0);
        while (i != -1) {
            value |= 1L << i;
            i = bs.nextSetBit(i + 1);
        }
        assert (value >= 0L);
        assert (Long.bitCount(value) == bs.cardinality()) : "Wrong cardinality for " + bs;
        return value;
    }

    public static void nonNegativeLongToLittleEndianBitSet(long value, BitSet bs) {
        Preconditions.checkArgument(value >= 0L, "Negative numbers are not allowed.");
        bs.clear();
        int bitLength = 64 - Long.numberOfLeadingZeros(value);
        assert (bitLength < 64) : "How could negative number " + value + " get here?";
        if (bitLength != 0) {
            int lowestSetBit = Long.numberOfTrailingZeros(value);
            assert (lowestSetBit != 64);
            for (int i = lowestSetBit; i < bitLength; ++i) {
                if ((value & 1L << i) == 0L) continue;
                bs.set(i);
            }
        }
    }
}

