/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.Util;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import com.yahoo.sketches.quantiles.HeapUpdateDoublesSketch;
import com.yahoo.sketches.quantiles.Util;
import java.util.Arrays;

final class DoublesUtil {
    private DoublesUtil() {
    }

    static HeapUpdateDoublesSketch copyToHeap(DoublesSketch sketch) {
        HeapUpdateDoublesSketch qsCopy = HeapUpdateDoublesSketch.newInstance(sketch.getK());
        qsCopy.putN(sketch.getN());
        qsCopy.putMinValue(sketch.getMinValue());
        qsCopy.putMaxValue(sketch.getMaxValue());
        qsCopy.putBaseBufferCount(sketch.getBaseBufferCount());
        qsCopy.putBitPattern(sketch.getBitPattern());
        if (sketch.isCompact()) {
            int combBufItems = com.yahoo.sketches.quantiles.Util.computeCombinedBufferItemCapacity(sketch.getK(), sketch.getN());
            double[] combBuf = new double[combBufItems];
            qsCopy.putCombinedBuffer(combBuf);
            DoublesSketchAccessor sketchAccessor = DoublesSketchAccessor.wrap(sketch);
            DoublesSketchAccessor copyAccessor = DoublesSketchAccessor.wrap(qsCopy);
            copyAccessor.putArray(sketchAccessor.getArray(0, sketchAccessor.numItems()), 0, 0, sketchAccessor.numItems());
            int lvl = 0;
            for (long bitPattern = sketch.getBitPattern(); bitPattern != 0L; bitPattern >>>= 1) {
                if ((bitPattern & 1L) > 0L) {
                    sketchAccessor.setLevel(lvl);
                    copyAccessor.setLevel(lvl);
                    copyAccessor.putArray(sketchAccessor.getArray(0, sketchAccessor.numItems()), 0, 0, sketchAccessor.numItems());
                }
                ++lvl;
            }
        } else {
            double[] combBuf = sketch.getCombinedBuffer();
            qsCopy.putCombinedBuffer(Arrays.copyOf(combBuf, combBuf.length));
        }
        return qsCopy;
    }

    static void checkDoublesSerVer(int serVer, int minSupportedSerVer) {
        int max2 = 3;
        if (serVer > 3 || serVer < minSupportedSerVer) {
            throw new SketchesArgumentException("Possible corruption: Unsupported Serialization Version: " + serVer);
        }
    }

    static String toString(boolean sketchSummary, boolean dataDetail, DoublesSketch sketch) {
        StringBuilder sb = new StringBuilder();
        if (dataDetail) {
            sb.append(DoublesUtil.getDataDetail(sketch));
        }
        if (sketchSummary) {
            sb.append(DoublesUtil.getSummary(sketch));
        }
        return sb.toString();
    }

    static String memToString(boolean sketchSummary, boolean dataDetail, Memory mem) {
        DoublesSketch ds = DoublesSketch.heapify(mem);
        return ds.toString(sketchSummary, dataDetail);
    }

    private static String getSummary(DoublesSketch sk) {
        StringBuilder sb = new StringBuilder();
        String thisSimpleName = sk.getClass().getSimpleName();
        int k = sk.getK();
        String kStr = String.format("%,d", k);
        long n = sk.getN();
        String nStr = String.format("%,d", n);
        String bbCntStr = String.format("%,d", sk.getBaseBufferCount());
        String combBufCapStr = String.format("%,d", sk.getCombinedBufferItemCapacity());
        long bitPattern = sk.getBitPattern();
        int neededLevels = com.yahoo.sketches.quantiles.Util.computeNumLevelsNeeded(k, n);
        int totalLevels = com.yahoo.sketches.quantiles.Util.computeTotalLevels(bitPattern);
        int validLevels = com.yahoo.sketches.quantiles.Util.computeValidLevels(bitPattern);
        String retItemsStr = String.format("%,d", sk.getRetainedItems());
        String cmptBytesStr = String.format("%,d", sk.getCompactStorageBytes());
        String updtBytesStr = String.format("%,d", sk.getUpdatableStorageBytes());
        double eps = Util.EpsilonFromK.getAdjustedEpsilon(k);
        String epsPctStr = String.format("%.3f%%", eps * 100.0);
        String memCap = sk.isDirect() ? Long.toString(sk.getMemory().getCapacity()) : "";
        sb.append(com.yahoo.sketches.quantiles.Util.LS).append("### Quantiles ").append(thisSimpleName).append(" SUMMARY: ").append(Util.LS);
        sb.append("   Empty                        : ").append(sk.isEmpty()).append(Util.LS);
        sb.append("   Direct, Capacity bytes       : ").append(sk.isDirect()).append(", ").append(memCap).append(Util.LS);
        sb.append("   Estimation Mode              : ").append(sk.isEstimationMode()).append(Util.LS);
        sb.append("   K                            : ").append(kStr).append(Util.LS);
        sb.append("   N                            : ").append(nStr).append(Util.LS);
        sb.append("   Levels (Needed, Total, Valid): ").append(neededLevels + ", " + totalLevels + ", " + validLevels).append(Util.LS);
        sb.append("   Level Bit Pattern            : ").append(Long.toBinaryString(bitPattern)).append(Util.LS);
        sb.append("   BaseBufferCount              : ").append(bbCntStr).append(Util.LS);
        sb.append("   Combined Buffer Capacity     : ").append(combBufCapStr).append(Util.LS);
        sb.append("   Retained Items               : ").append(retItemsStr).append(Util.LS);
        sb.append("   Compact Storage Bytes        : ").append(cmptBytesStr).append(Util.LS);
        sb.append("   Updatable Storage Bytes      : ").append(updtBytesStr).append(Util.LS);
        sb.append("   Normalized Rank Error        : ").append(epsPctStr).append(Util.LS);
        sb.append("   Min Value                    : ").append(String.format("%,.3f", sk.getMinValue())).append(Util.LS);
        sb.append("   Max Value                    : ").append(String.format("%,.3f", sk.getMaxValue())).append(Util.LS);
        sb.append("### END SKETCH SUMMARY").append(Util.LS);
        return sb.toString();
    }

    private static String getDataDetail(DoublesSketch sketchIn) {
        DoublesSketch sketch = sketchIn.isCompact() ? DoublesUtil.copyToHeap(sketchIn) : sketchIn;
        StringBuilder sb = new StringBuilder();
        String skName = sketch.getClass().getSimpleName();
        sb.append(Util.LS).append("### Quantiles ").append(skName).append(" DATA DETAIL: ").append(Util.LS);
        int k = sketch.getK();
        long n = sketch.getN();
        int bbCount = sketch.getBaseBufferCount();
        long bitPattern = sketch.getBitPattern();
        double[] combBuf = sketch.getCombinedBuffer();
        sb.append("   BaseBuffer   : ");
        for (int i = 0; i < bbCount; ++i) {
            sb.append(String.format("%10.1f", combBuf[i]));
        }
        sb.append(Util.LS);
        int combBufSize = combBuf.length;
        if (n >= (long)(2 * k)) {
            sb.append("   Valid | Level");
            for (int j = 2 * k; j < combBufSize; ++j) {
                if (j % k == 0) {
                    int levelNum = j / k - 2;
                    String validLvl = (1L << levelNum & bitPattern) > 0L ? "    T  " : "    F  ";
                    String lvl = String.format("%5d", levelNum);
                    sb.append(Util.LS).append("   ").append(validLvl).append(" ").append(lvl).append(": ");
                }
                sb.append(String.format("%10.1f", combBuf[j]));
            }
            sb.append(Util.LS);
        }
        sb.append("### END DATA DETAIL").append(Util.LS);
        return sb.toString();
    }
}

