/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.dingodb.common.codec.PrimitiveCodec;
import io.dingodb.common.util.ByteArrayUtils;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class CommonId
implements Comparable<CommonId>,
Serializable {
    private static final long serialVersionUID = 3355195360067107406L;
    public static final int TYPE_LEN = 1;
    public static final int IDENTIFIER_LEN = 2;
    public static final int DOMAIN_LEN = 4;
    public static final int SEQ_LEN = 4;
    public static final int LEN = 11;
    public static final int TYPE_IDX = 0;
    public static final int IDENTIFIER_IDX = 1;
    public static final int DOMAIN_IDX = 3;
    public static final int SEQ_IDX = 7;
    private byte[] content;
    private byte type;
    private byte[] identifier;
    private byte[] domain;
    private byte[] seq;
    private volatile transient String str;

    private CommonId() {
    }

    public CommonId(byte type2, byte[] identifier, byte[] domain, int seq) {
        this(type2, identifier, domain, PrimitiveCodec.encodeInt(seq));
    }

    public CommonId(byte type2, byte[] identifier, byte[] domain, byte[] seq) {
        if (identifier.length > 2) {
            throw new IllegalArgumentException("Identifier length must 2");
        }
        if (domain.length > 4) {
            throw new IllegalArgumentException("Identifier length must 4");
        }
        this.type = type2;
        this.identifier = new byte[]{identifier[0], identifier[1]};
        this.domain = new byte[]{domain[0], domain[1], domain[2], domain[3]};
        this.seq = new byte[]{seq[0], seq[1], seq[2], seq[3]};
        this.content = new byte[]{type2, identifier[0], identifier[1], domain[0], domain[1], domain[2], domain[3], seq[0], seq[1], seq[2], seq[3]};
    }

    @Override
    public int compareTo(CommonId other) {
        return ByteArrayUtils.compare(this.content, other.content);
    }

    public byte[] content() {
        byte[] content = new byte[this.content.length];
        System.arraycopy(this.content, 0, content, 0, content.length);
        return content;
    }

    public byte type() {
        return this.type;
    }

    public byte[] identifier() {
        return new byte[]{this.identifier[0], this.identifier[1]};
    }

    public int domain() {
        return PrimitiveCodec.readInt(this.domain);
    }

    public byte[] domainContent() {
        return new byte[]{this.domain[0], this.domain[1], this.domain[2], this.domain[3]};
    }

    public int seq() {
        return PrimitiveCodec.readInt(this.seq);
    }

    public byte[] seqContent() {
        return new byte[]{this.seq[0], this.seq[1], this.seq[2], this.seq[3]};
    }

    public String toString() {
        if (this.str == null) {
            Integer seq;
            String str = new String(new byte[]{this.type, 45, this.identifier[0], this.identifier[1]});
            Integer namespace = PrimitiveCodec.readInt(this.domain);
            if (namespace != null) {
                str = str + "-" + namespace;
            }
            if ((seq = PrimitiveCodec.readInt(this.seq)) != null) {
                str = str + "-" + seq;
            }
            this.str = str;
        }
        return this.str;
    }

    public byte[] encode() {
        byte[] encode = new byte[this.content.length];
        System.arraycopy(this.content, 0, encode, 0, encode.length);
        return encode;
    }

    public static CommonId decode(byte[] content) {
        return new CommonId(content[0], new byte[]{content[1], content[2]}, new byte[]{content[3], content[4], content[5], content[6]}, new byte[]{content[7], content[8], content[9], content[10]});
    }

    public static CommonId decode(ByteBuffer buffer) {
        CommonId result = CommonId.decode(buffer.array());
        buffer.position(buffer.position() + 11);
        return result;
    }

    public static CommonId prefix(byte type2) {
        CommonId commonId = new CommonId();
        commonId.type = type2;
        commonId.identifier = new byte[]{48, 48};
        commonId.content = new byte[]{commonId.type, commonId.identifier[0], commonId.identifier[1]};
        return commonId;
    }

    public static CommonId prefix(byte type2, byte[] identifier) {
        CommonId commonId = new CommonId();
        commonId.type = type2;
        commonId.identifier = new byte[]{identifier[0], identifier[1]};
        commonId.content = new byte[]{commonId.type, commonId.identifier[0], commonId.identifier[1]};
        return commonId;
    }

    public static CommonId prefix(byte type2, byte[] identifier, byte[] domain) {
        CommonId commonId = new CommonId();
        commonId.type = type2;
        commonId.identifier = new byte[]{identifier[0], identifier[1]};
        commonId.domain = new byte[]{domain[0], domain[1], domain[2], domain[3]};
        commonId.content = new byte[]{commonId.type, commonId.identifier[0], commonId.identifier[1], commonId.domain[0], commonId.domain[1], commonId.domain[2], commonId.domain[3]};
        return commonId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonId)) {
            return false;
        }
        CommonId other = (CommonId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.content, other.content);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommonId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.content);
        return result;
    }

    public static class JacksonDeserializer
    extends StdDeserializer<CommonId> {
        protected JacksonDeserializer() {
            super(CommonId.class);
        }

        @Override
        public CommonId deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            return CommonId.decode(parser.getBinaryValue());
        }
    }

    public static class JacksonSerializer
    extends StdSerializer<CommonId> {
        protected JacksonSerializer() {
            super(CommonId.class);
        }

        @Override
        public void serialize(CommonId value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeBinary(value.content);
        }
    }
}

