/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.InetSocketAddress;

public class Location
implements Serializable {
    private static final long serialVersionUID = 4013504472715015258L;
    @JsonProperty(value="host")
    private final String host;
    @JsonProperty(value="port")
    private final int port;
    @JsonProperty(value="raftPort")
    private final int raftPort;
    private final String url;

    public Location(String host, int port) {
        this(host, port, 0);
    }

    @JsonCreator
    public Location(@JsonProperty(value="host") String host, @JsonProperty(value="port") int port, @JsonProperty(value="raftPort") int raftPort) {
        this.host = host;
        this.port = port;
        this.raftPort = raftPort;
        this.url = String.format("%s:%s", host, port);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int raftPort() {
        return this.raftPort;
    }

    public InetSocketAddress toSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public boolean equals(Object other) {
        return other == this || other instanceof Location && this.url.equals(((Location)other).url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return "Location(host=" + this.getHost() + ", port=" + this.getPort() + ", raftPort=" + this.getRaftPort() + ")";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getRaftPort() {
        return this.raftPort;
    }

    public String getUrl() {
        return this.url;
    }
}

