/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.codec;

import io.dingodb.common.codec.Codec;
import io.dingodb.common.type.TupleMapping;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;

public class AvroCodec
implements Codec {
    private static final ThreadLocal<BinaryDecoder> decoderLocal = ThreadLocal.withInitial(() -> null);
    private static final ThreadLocal<BinaryEncoder> encoderLocal = ThreadLocal.withInitial(() -> null);
    private final Schema schema;
    private final DatumReader<GenericRecord> reader;
    private final DatumWriter<GenericRecord> writer;

    public AvroCodec(@Nonnull Schema schema) {
        this.schema = schema;
        this.reader = new GenericDatumReader<GenericRecord>(schema);
        this.writer = new GenericDatumWriter<GenericRecord>(schema);
    }

    private static GenericRecord decodeBytes(InputStream is, @Nonnull DatumReader<GenericRecord> reader) throws IOException {
        BinaryDecoder decoder = decoderLocal.get();
        decoder = DecoderFactory.get().directBinaryDecoder(is, decoder);
        decoderLocal.set(decoder);
        return reader.read(null, decoder);
    }

    private static void encodeBytes(OutputStream os, GenericRecord record, @Nonnull DatumWriter<GenericRecord> writer) throws IOException {
        BinaryEncoder encoder = encoderLocal.get();
        encoder = EncoderFactory.get().directBinaryEncoder(os, encoder);
        encoderLocal.set(encoder);
        writer.write(record, encoder);
    }

    public void encode(OutputStream os, @Nonnull Object[] tuple) throws IOException {
        GenericData.Record record = new GenericData.Record(this.schema);
        for (int i = 0; i < tuple.length; ++i) {
            record.put(i, tuple[i]);
        }
        AvroCodec.encodeBytes(os, record, this.writer);
    }

    public void encode(OutputStream os, @Nonnull Object[] tuple, @Nonnull TupleMapping mapping) throws IOException {
        GenericData.Record record = new GenericData.Record(this.schema);
        for (int i = 0; i < mapping.size(); ++i) {
            record.put(i, tuple[mapping.get(i)]);
        }
        AvroCodec.encodeBytes(os, record, this.writer);
    }

    @Override
    public byte[] encode(@Nonnull Object[] tuple) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.encode(os, tuple);
        return os.toByteArray();
    }

    @Override
    public byte[] encode(@Nonnull Object[] tuple, @Nonnull TupleMapping mapping) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.encode(os, tuple, mapping);
        return os.toByteArray();
    }

    @Override
    public byte[] encode(@Nonnull byte[] origin, @Nonnull Object[] tuple, @Nonnull int[] schemaIndex) throws IOException, ClassCastException {
        return new byte[0];
    }

    public Object[] decode(@Nonnull InputStream is) throws IOException {
        GenericRecord keyRecord = AvroCodec.decodeBytes(is, this.reader);
        int size = this.schema.getFields().size();
        Object[] tuple = new Object[size];
        for (int i = 0; i < size; ++i) {
            tuple[i] = keyRecord.get(i);
        }
        return tuple;
    }

    @Override
    public Object[] decode(@Nonnull byte[] bytes) throws IOException {
        return this.decode(new ByteArrayInputStream(bytes));
    }

    @Override
    public Object[] decode(Object[] result, byte[] bytes, @Nonnull TupleMapping mapping) throws IOException {
        Object[] tuple = this.decode(bytes);
        mapping.map(result, tuple);
        return result;
    }

    @Override
    public Object[] decode(byte[] bytes, @Nonnull int[] schemaIndex) throws IOException {
        return new Object[0];
    }
}

