/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.codec;

import io.dingodb.common.codec.Codec;
import io.dingodb.common.type.TupleMapping;
import io.dingodb.serial.io.RecordDecoder;
import io.dingodb.serial.io.RecordEncoder;
import io.dingodb.serial.schema.DingoSchema;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

public class DingoCodec
implements Codec {
    private RecordEncoder re;
    private RecordDecoder rd;
    TupleMapping mapping;

    public DingoCodec(List<DingoSchema> schemas) {
        this(schemas, null, false);
    }

    public DingoCodec(List<DingoSchema> schemas, TupleMapping mapping) {
        this(schemas, mapping, false);
    }

    public DingoCodec(List<DingoSchema> schemas, TupleMapping mapping, boolean isKey) {
        this.re = new RecordEncoder(schemas, 0, isKey);
        this.rd = new RecordDecoder(schemas, 0, isKey);
        this.mapping = mapping;
    }

    @Override
    public byte[] encode(@Nonnull Object[] tuple) throws IOException, ClassCastException {
        return this.re.encode(tuple);
    }

    @Override
    public byte[] encodeKey(@Nonnull Object[] tuple) throws IOException, ClassCastException {
        return this.re.encodeKey(tuple);
    }

    @Override
    public byte[] encodeKeyForRangeScan(@Nonnull Object[] tuple) throws IOException, ClassCastException {
        return this.re.encodeKeyWithoutLength(tuple);
    }

    @Override
    public byte[] encode(@Nonnull Object[] tuple, @Nonnull TupleMapping mapping) throws IOException, ClassCastException {
        Object[] newTuple = new Object[mapping.size()];
        int i = 0;
        for (int index : mapping.getMappings()) {
            newTuple[index] = tuple[i++];
        }
        return this.re.encode(newTuple);
    }

    @Override
    public byte[] encodeKey(@Nonnull Object[] tuple, @Nonnull TupleMapping mapping) throws IOException, ClassCastException {
        Object[] newTuple = new Object[mapping.size()];
        int i = 0;
        for (int index : mapping.getMappings()) {
            newTuple[index] = tuple[i++];
        }
        return this.re.encodeKey(newTuple);
    }

    @Override
    public byte[] encode(@Nonnull byte[] origin, @Nonnull Object[] tuple, @Nonnull int[] schemaIndex) throws IOException, ClassCastException {
        return this.re.encode(origin, schemaIndex, tuple);
    }

    @Override
    public byte[] encodeKey(@Nonnull byte[] origin, @Nonnull Object[] tuple, @Nonnull int[] schemaIndex) throws IOException, ClassCastException {
        return this.re.encodeKey(origin, schemaIndex, tuple);
    }

    @Override
    public Object[] decode(@Nonnull byte[] bytes) throws IOException {
        return this.rd.decode(bytes);
    }

    @Override
    public Object[] decodeKey(@Nonnull byte[] bytes) throws IOException {
        return this.rd.decodeKey(bytes);
    }

    @Override
    public Object[] decode(Object[] result, byte[] bytes, @Nonnull TupleMapping mapping) throws IOException {
        Object[] tuple = this.decode(bytes);
        mapping.map(result, tuple);
        return result;
    }

    @Override
    public Object[] decodeKey(Object[] result, byte[] bytes, @Nonnull TupleMapping mapping) throws IOException {
        Object[] tuple = this.decodeKey(bytes);
        mapping.map(result, tuple);
        return result;
    }

    @Override
    public Object[] decode(byte[] bytes, @Nonnull int[] schemaIndex) throws IOException {
        return this.rd.decode(bytes, schemaIndex);
    }

    @Override
    public Object[] decodeKey(byte[] bytes, @Nonnull int[] schemaIndex) throws IOException {
        return this.rd.decodeKey(bytes, schemaIndex);
    }
}

