/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.codec;

import io.dingodb.common.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class PrimitiveCodec {
    public static final int INT_MAX_LEN = 5;
    public static final int LONG_MAX_LEN = 10;

    private PrimitiveCodec() {
    }

    public static int computeVarIntSize(int value) {
        int count = 0;
        while ((value & 0xFFFFFF80) != 0) {
            ++count;
            value >>>= 7;
        }
        return ++count;
    }

    public static byte[] encodeInt(int value) {
        byte[] result = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return result;
    }

    public static byte[] encodeLong(long value) {
        byte[] result = new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return result;
    }

    public static byte[] encodeVarInt(int value) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(5);
        while ((value & 0xFFFFFF80) != 0) {
            outputStream.write((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        outputStream.write((byte)value);
        return outputStream.toByteArray();
    }

    public static byte[] encodeVarLong(long value) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(10);
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            outputStream.write((byte)(value & 0x7FL | 0x80L));
            value >>>= 7;
        }
        outputStream.write((byte)value);
        return outputStream.toByteArray();
    }

    public static byte[] encodeZigZagInt(int value) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(5);
        if (((value = value << 1 ^ value >> 31) & 0xFFFFFF80) != 0) {
            outputStream.write((byte)((value | 0x80) & 0xFF));
            if ((value >>>= 7) > 127) {
                outputStream.write((byte)((value | 0x80) & 0xFF));
                if ((value >>>= 7) > 127) {
                    outputStream.write((byte)((value | 0x80) & 0xFF));
                    if ((value >>>= 7) > 127) {
                        outputStream.write((byte)((value | 0x80) & 0xFF));
                        value >>>= 7;
                    }
                }
            }
        }
        outputStream.write((byte)value);
        return outputStream.toByteArray();
    }

    public static Integer readInt(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return bytes[3] & 0xFF | (bytes[2] & 0xFF) << 8 | (bytes[1] & 0xFF) << 16 | (bytes[0] & 0xFF) << 24;
    }

    public static Long readLong(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return (long)bytes[7] & 0xFFL | ((long)bytes[6] & 0xFFL) << 8 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[0] & 0xFFL) << 56;
    }

    public static Integer readVarInt(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int position = 0;
        int b = 128;
        int result = 0;
        int maxBytes = 5;
        while (maxBytes >= 0 && b > 127) {
            b = bytes[position++] & 0xFF;
            result ^= (b & 0x7F) << (5 - maxBytes--) * 7;
        }
        return result;
    }

    public static Integer readVarInt(ByteBuffer buf) {
        int readerIndex = buf.position();
        int maxBytes = 5;
        int b = 128;
        int result = 0;
        while (maxBytes >= 0 && b > 127) {
            if (!buf.hasRemaining()) {
                buf.position(readerIndex);
                return null;
            }
            b = buf.get() & 0xFF;
            result ^= (b & 0x7F) << (5 - maxBytes--) * 7;
        }
        return result;
    }

    public static Integer readVarInt(ByteArrayInputStream bais) {
        bais.mark(0);
        int maxBytes = 5;
        int b = 128;
        int result = 0;
        while (maxBytes >= 0 && b > 127) {
            if (bais.available() < 1) {
                bais.reset();
                return null;
            }
            b = bais.read() & 0xFF;
            result ^= (b & 0x7F) << (5 - maxBytes--) * 7;
        }
        return result;
    }

    public static Long readVarLong(byte[] bytes) {
        int position = 0;
        int maxBytes = 10;
        long b = 128L;
        long result = 0L;
        while (maxBytes >= 0 && b > 127L) {
            b = bytes[position++] & 0xFF;
            result ^= (b & 0x7FL) << (10 - maxBytes--) * 7;
        }
        return result;
    }

    public static Long readVarLong(ByteBuffer buf) {
        int readerIndex = buf.position();
        int maxBytes = 10;
        long b = 128L;
        long result = 0L;
        while (maxBytes >= 0 && b > 127L) {
            if (!buf.hasRemaining()) {
                buf.position(readerIndex);
                return null;
            }
            b = buf.get() & 0xFF;
            result ^= (b & 0x7FL) << (10 - maxBytes--) * 7;
        }
        return result;
    }

    public static int readZigZagInt(byte[] bytes) {
        int position = 0;
        int b = 128;
        int result = 0;
        int maxBytes = 5;
        while (maxBytes >= 0 && b > 127) {
            b = bytes[position++] & 0xFF;
            result ^= (b & 0x7F) << (5 - maxBytes--) * 7;
        }
        return result >>> 1 ^ -(result & 1);
    }

    public static Integer readZigZagInt(ByteBuffer buf) {
        int readerIndex = buf.position();
        int maxBytes = 5;
        int b = 128;
        int result = 0;
        while (maxBytes >= 0 && b > 127) {
            if (!buf.hasRemaining()) {
                buf.position(readerIndex);
                return null;
            }
            b = buf.get() & 0xFF;
            result = (int)((long)result ^ ((long)b & 0x7FL) << (5 - maxBytes--) * 7);
        }
        return result >>> 1 ^ -(result & 1);
    }

    public static Integer readZigZagInt(ByteArrayInputStream bais) {
        bais.mark(0);
        int maxBytes = 5;
        int b = 128;
        int result = 0;
        while (maxBytes >= 0 && b > 127) {
            if (bais.available() < 1) {
                bais.reset();
                return null;
            }
            b = bais.read() & 0xFF;
            result = (int)((long)result ^ ((long)b & 0x7FL) << (5 - maxBytes--) * 7);
        }
        return result >>> 1 ^ -(result & 1);
    }

    public static byte[] encodeString(String str) {
        if (str == null) {
            return new byte[]{0};
        }
        byte[] content = str.getBytes(StandardCharsets.UTF_8);
        byte[] len2 = PrimitiveCodec.encodeVarInt(content.length);
        byte[] result = new byte[len2.length + content.length];
        System.arraycopy(len2, 0, result, 0, len2.length);
        System.arraycopy(content, 0, result, len2.length, content.length);
        return result;
    }

    public static String readString(byte[] bytes) {
        Integer len2 = PrimitiveCodec.readVarInt(bytes);
        if (len2 == null || len2 < 0) {
            return null;
        }
        return new String(bytes, PrimitiveCodec.computeVarIntSize(len2), (int)len2);
    }

    public static String readString(ByteBuffer buf) {
        int readerIndex = buf.position();
        Integer len2 = PrimitiveCodec.readVarInt(buf);
        if (len2 == null || len2 < 0 || buf.limit() - buf.position() < len2) {
            buf.position(readerIndex);
            return null;
        }
        byte[] bytes = new byte[len2.intValue()];
        buf.get(bytes);
        return new String(bytes);
    }

    public static String readString(ByteArrayInputStream bais) {
        bais.mark(0);
        Integer len2 = PrimitiveCodec.readVarInt(bais);
        if (len2 == null || len2 < 0 || bais.available() < len2) {
            bais.reset();
            return null;
        }
        byte[] bytes = new byte[len2.intValue()];
        for (int i = 0; i < len2; ++i) {
            bytes[i] = (byte)bais.read();
        }
        return new String(bytes);
    }

    public static byte[] encodeArray(byte[] content) {
        if (content == null) {
            return new byte[]{0};
        }
        byte[] len2 = PrimitiveCodec.encodeVarInt(content.length);
        byte[] result = new byte[len2.length + content.length];
        System.arraycopy(len2, 0, result, 0, len2.length);
        System.arraycopy(content, 0, result, len2.length, content.length);
        return result;
    }

    public static Pair<byte[], Integer> decodeArray(byte[] bytes, int offset) {
        byte[] lenBytes = Arrays.copyOfRange(bytes, offset, offset + 4);
        Integer len2 = PrimitiveCodec.readVarInt(lenBytes);
        if (len2 == null || len2 < 0) {
            return null;
        }
        int lenOffset = PrimitiveCodec.computeVarIntSize(len2);
        int totalOffset = offset + lenOffset + len2;
        return new Pair<byte[], Integer>(Arrays.copyOfRange(bytes, offset + lenOffset, totalOffset), lenOffset + len2);
    }
}

