/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.codec;

import io.dingodb.common.codec.protostuff.DateSchema;
import io.dingodb.common.codec.protostuff.TimeSchema;
import io.dingodb.common.codec.protostuff.TimestampSchema;
import io.dingodb.common.error.CommonError;
import io.dingodb.common.util.StackTraces;
import io.protostuff.ByteBufferInput;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffOutput;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public final class ProtostuffCodec {
    private static final ProtostuffCodec INSTANCE = new ProtostuffCodec();
    private static final ThreadLocal<LinkedBuffer> buffer = ThreadLocal.withInitial(() -> LinkedBuffer.allocate(1024));
    private final Schema<ProtostuffWrapper> schema;

    private ProtostuffCodec() {
        System.setProperty("protostuff.runtime.preserve_null_elements", "true");
        System.setProperty("protostuff.runtime.morph_collection_interfaces", "true");
        System.setProperty("protostuff.runtime.morph_map_interfaces", "true");
        System.setProperty("protostuff.runtime.morph_non_final_pojos", "true");
        RuntimeSchema.register(Date.class, DateSchema.INSTANCE);
        RuntimeSchema.register(Time.class, TimeSchema.INSTANCE);
        RuntimeSchema.register(Timestamp.class, TimestampSchema.INSTANCE);
        this.schema = RuntimeSchema.getSchema(ProtostuffWrapper.class);
    }

    public static <T> T read(byte[] bytes) {
        return INSTANCE.readMessage(ByteBuffer.wrap(bytes), null);
    }

    public static <T> T read(byte[] bytes, T source) {
        return INSTANCE.readMessage(ByteBuffer.wrap(bytes), source);
    }

    public static <T> T read(ByteBuffer buffer) {
        return INSTANCE.readMessage(buffer, null);
    }

    public static <T> T read(ByteBuffer buffer, T source) {
        return INSTANCE.readMessage(buffer, source);
    }

    public static byte[] write(Object value) {
        return INSTANCE.writeMessage(value);
    }

    private <T> T readMessage(ByteBuffer buffer, T source) {
        ProtostuffWrapper wrapper2 = new ProtostuffWrapper(source);
        ByteBufferInput input = new ByteBufferInput(buffer, true);
        try {
            this.schema.mergeFrom(input, wrapper2);
        }
        catch (IOException e) {
            CommonError.EXEC.throwFormatError("protostuff read", Thread.currentThread(), e.getMessage());
        }
        return (T)wrapper2.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeMessage(Object value) {
        ProtostuffOutput output = new ProtostuffOutput(buffer.get());
        try {
            this.schema.writeTo(output, new ProtostuffWrapper(value));
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            CommonError.EXEC.throwFormatError("protostuff write", Thread.currentThread(), e.getMessage());
        }
        finally {
            buffer.get().clear();
        }
        throw CommonError.UNKNOWN.asException(StackTraces.stack());
    }

    static class ProtostuffWrapper {
        private Object value;

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public ProtostuffWrapper() {
        }

        public ProtostuffWrapper(Object value) {
            this.value = value;
        }
    }
}

