/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.concurrent;

import io.dingodb.common.concurrent.ThreadPoolBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Executors {
    private static final Logger log = LoggerFactory.getLogger(Executors.class);
    private static final String THREAD_NAME_FORMAT = "%s-%d";
    private static final String FREE_THREAD_NAME = "FREE";
    public static final String GLOBAL_NAME = "GLOBAL";
    public static final String GLOBAL_SCHEDULE_NAME = "GLOBAL_SCHEDULE";
    private static final ThreadPoolExecutor GLOBAL_POOL = new ThreadPoolBuilder().name("GLOBAL").coreThreads(0).maximumThreads(Integer.MAX_VALUE).keepAliveSeconds(TimeUnit.MINUTES.toSeconds(1L)).workQueue(new SynchronousQueue<Runnable>()).daemon(true).group(new ThreadGroup("GLOBAL")).build();
    private static final ScheduledThreadPoolExecutor GLOBAL_SCHEDULE_POOL = new ThreadPoolBuilder().name("GLOBAL_SCHEDULE").daemon(true).coreThreads(1).group(new ThreadGroup("GLOBAL_SCHEDULE")).buildSchedule();

    private Executors() {
    }

    public static Executor executor(String name) {
        return command -> Executors.execute(name, command);
    }

    public static void execute(String name, Runnable command) {
        GLOBAL_POOL.execute(Executors.wrap(name, command));
    }

    public static ScheduledFuture<CompletableFuture<?>> scheduleAsync(String name, Runnable command, long delay, TimeUnit unit) {
        return GLOBAL_SCHEDULE_POOL.schedule(() -> Executors.submit(name, command), delay, unit);
    }

    public static ScheduledFuture<CompletableFuture<?>> scheduleAsync(String name, Callable<?> command, long delay, TimeUnit unit) {
        return GLOBAL_SCHEDULE_POOL.schedule(() -> Executors.submit(name, command), delay, unit);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelayAsync(String name, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return GLOBAL_SCHEDULE_POOL.scheduleWithFixedDelay(() -> Executors.execute(name, command), initialDelay, period, unit);
    }

    public static ScheduledFuture<?> scheduleAtFixedRateAsync(String name, Runnable command, long initialDelay, long period, TimeUnit unit) {
        return GLOBAL_SCHEDULE_POOL.scheduleAtFixedRate(() -> Executors.execute(name, command), initialDelay, period, unit);
    }

    public static <T> CompletableFuture<T> submit(String name, Callable<T> task) {
        CompletableFuture future = new CompletableFuture();
        GLOBAL_POOL.execute(() -> {
            try {
                future.complete(Executors.wrap(name, task).call());
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static <T> CompletableFuture<T> submit(String name, Runnable task, T result) {
        CompletableFuture future = new CompletableFuture();
        GLOBAL_POOL.execute(() -> {
            try {
                Executors.wrap(name, task).run();
                future.complete(result);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static CompletableFuture<Void> submit(String name, Runnable task) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        GLOBAL_POOL.execute(() -> {
            try {
                Executors.wrap(name, task).run();
                future.complete(null);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private static <V> Callable<V> wrap(String name, Callable<V> callable) {
        return () -> Executors.call(name, callable);
    }

    private static Runnable wrap(String name, Runnable runnable) {
        return () -> Executors.run(name, runnable);
    }

    private static <V> V call(String name, Callable<V> callable) throws Exception {
        Thread thread = Thread.currentThread();
        try {
            if (log.isTraceEnabled()) {
                log.trace("Call [{}] start, thread id [{}], set thread name.", (Object)name, (Object)thread.getId());
            }
            thread.setName(String.format(THREAD_NAME_FORMAT, name, thread.getId()));
            V v = callable.call();
            return v;
        }
        catch (Throwable e) {
            log.error("Execute {} catch error.", (Object)name, (Object)e);
            throw e;
        }
        finally {
            thread.setName(FREE_THREAD_NAME);
            if (log.isTraceEnabled()) {
                log.trace("Call [{}] finish, thread id [{}], reset thread name.", (Object)name, (Object)thread.getId());
            }
        }
    }

    private static void run(String name, Runnable runnable) {
        Thread thread = Thread.currentThread();
        try {
            if (log.isTraceEnabled()) {
                log.trace("Run [{}] start, thread id [{}], set thread name.", (Object)name, (Object)thread.getId());
            }
            thread.setName(String.format(THREAD_NAME_FORMAT, name, thread.getId()));
            runnable.run();
        }
        catch (Throwable e) {
            log.error("Execute {} catch error.", (Object)name, (Object)e);
            throw e;
        }
        finally {
            thread.setName(FREE_THREAD_NAME);
            if (log.isTraceEnabled()) {
                log.trace("Run [{}] finish, thread id [{}], reset thread name.", (Object)name, (Object)thread.getId());
            }
        }
    }
}

