/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.concurrent;

import io.dingodb.common.concurrent.Executors;
import io.dingodb.common.util.Unsafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LinkedRunner
implements Unsafe {
    private static final Logger log = LoggerFactory.getLogger(LinkedRunner.class);
    private static final String NAME = "linked-runner";
    private static final Unsafe.UnsafeAccessor UNSAFE = Unsafe.getAccessor();
    private static final Runnable EMPTY = () -> {};
    private static final long COMPLETE_OFFSET;
    private static final long NEXT_OFFSET;
    private static final long AVAILABLE_OFFSET;
    public final String name;
    private int available = 1;
    private RunnerNode current;
    private RunnerNode last;

    public LinkedRunner(String name) {
        this.name = name;
        this.last = new RunnerNode(EMPTY, this);
        this.last.run();
    }

    public boolean hasNext() {
        return this.current != null && this.current != this.last;
    }

    public boolean follow(Runnable task) {
        return this.last.follow(new RunnerNode(task, this));
    }

    public boolean follow(RunnerNode next2) {
        return this.last.follow(next2);
    }

    public void forceFollow(Runnable task) {
        this.forceFollow(new RunnerNode(task, this));
    }

    public void forceFollow(RunnerNode next2) {
        while (!this.last.follow(next2)) {
            if (UNSAFE.compareAndSwapInt(this, AVAILABLE_OFFSET, 1, 1)) continue;
            throw new RuntimeException("Not available.");
        }
    }

    public void reset() {
        this.current = null;
        this.last = new RunnerNode(EMPTY, this);
        this.last.run();
        this.available = 1;
    }

    public void clear() {
        this.available = 0;
        LinkedRunner.removeNext(this.current);
    }

    private static void removeNext(RunnerNode node) {
        if (node.next != null) {
            LinkedRunner.removeNext(node);
        }
        node.next = null;
    }

    private void submit(RunnerNode node) {
        Executors.execute(this.name, () -> {
            RunnerNode next2 = node;
            while (true) {
                next2.run();
                if (UNSAFE.compareAndSwapObject(next2, NEXT_OFFSET, null, null) || !UNSAFE.compareAndSwapInt(next2, COMPLETE_OFFSET, 1, 2)) break;
                next2 = next2.next;
            }
        });
    }

    public String name() {
        return this.name;
    }

    public int available() {
        return this.available;
    }

    public RunnerNode current() {
        return this.current;
    }

    public RunnerNode last() {
        return this.last;
    }

    static {
        try {
            COMPLETE_OFFSET = UNSAFE.objectFieldOffset(RunnerNode.class.getDeclaredField("complete"));
            NEXT_OFFSET = UNSAFE.objectFieldOffset(RunnerNode.class.getDeclaredField("next"));
            AVAILABLE_OFFSET = UNSAFE.objectFieldOffset(LinkedRunner.class.getDeclaredField("available"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final class Fields {
        public static final String name = "name";
        public static final String available = "available";
        public static final String current = "current";
        public static final String last = "last";

        private Fields() {
        }
    }

    public static class RunnerNode
    implements Runnable,
    Unsafe {
        private final Runnable task;
        private final LinkedRunner runner;
        private int complete = 0;
        private RunnerNode next = null;

        public RunnerNode(Runnable task, LinkedRunner runner) {
            this.task = task;
            this.runner = runner;
        }

        protected boolean follow(RunnerNode next2) {
            if (UNSAFE.compareAndSwapObject(this, NEXT_OFFSET, null, next2)) {
                this.runner.last = next2;
                if (UNSAFE.compareAndSwapInt(this, COMPLETE_OFFSET, 1, 2)) {
                    this.runner.submit(next2);
                }
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.runner.current = this;
            try {
                this.task.run();
            }
            catch (Exception e) {
                log.error("Execute task [{}] error, the exception should be handled within the task.", (Object)this.runner.name, (Object)e);
            }
            UNSAFE.compareAndSwapInt(this, COMPLETE_OFFSET, 0, 1);
        }

        private void complete() {
            Executors.execute(this.runner.name, this.next);
        }

        public static final class Fields {
            public static final String task = "task";
            public static final String runner = "runner";
            public static final String complete = "complete";
            public static final String next = "next";

            private Fields() {
            }
        }
    }
}

