/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadFactoryBuilder {
    private static final Logger log = LoggerFactory.getLogger(ThreadFactoryBuilder.class);
    public static final String DEFAULT_NAME = "default-thread";
    private String name;
    private boolean daemon = false;
    private int priority = 5;
    private ThreadGroup group = Thread.currentThread().getThreadGroup();

    public ThreadFactoryBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ThreadFactoryBuilder daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder group(ThreadGroup group) {
        this.group = group;
        return this;
    }

    public ThreadFactory build() {
        return new ThreadFactory(){
            private final AtomicInteger index = new AtomicInteger(0);

            @Override
            public Thread newThread(@Nonnull Runnable runnable) {
                String threadName = String.format("%s-thread-%d", ThreadFactoryBuilder.this.name, this.index.incrementAndGet());
                Thread thread = new Thread(ThreadFactoryBuilder.this.group, runnable, threadName);
                thread.setDaemon(ThreadFactoryBuilder.this.daemon);
                thread.setPriority(ThreadFactoryBuilder.this.priority);
                return thread;
            }
        };
    }
}

