/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.concurrent;

import io.dingodb.common.concurrent.ThreadFactoryBuilder;
import io.dingodb.common.util.Parameters;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolBuilder {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolBuilder.class);
    public static final Integer AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    public static final RejectedExecutionHandler DEFAULT_HANDLER = new ThreadPoolExecutor.AbortPolicy();
    private String name;
    private Integer coreThreads = AVAILABLE_PROCESSORS;
    private Integer maximumThreads = AVAILABLE_PROCESSORS << 2;
    private Long keepAliveSeconds = 60L;
    private BlockingQueue<Runnable> workQueue;
    private ThreadFactory threadFactory;
    private RejectedExecutionHandler handler;
    private boolean daemon = false;
    private int priority = 5;
    private ThreadGroup group = Thread.currentThread().getThreadGroup();

    public ThreadPoolBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ThreadPoolBuilder coreThreads(Integer coreThreads) {
        this.coreThreads = coreThreads;
        return this;
    }

    public ThreadPoolBuilder maximumThreads(Integer maximumThreads) {
        this.maximumThreads = maximumThreads;
        return this;
    }

    public ThreadPoolBuilder keepAliveSeconds(Long keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds;
        return this;
    }

    public ThreadPoolBuilder workQueue(BlockingQueue<Runnable> workQueue) {
        this.workQueue = workQueue;
        return this;
    }

    public ThreadPoolBuilder threadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public ThreadPoolBuilder handler(RejectedExecutionHandler handler) {
        this.handler = handler;
        return this;
    }

    public ThreadPoolBuilder daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadPoolBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ThreadPoolBuilder group(ThreadGroup group) {
        this.group = group;
        return this;
    }

    protected ThreadFactory generateThreadFactory() {
        return new ThreadFactoryBuilder().name(this.name).daemon(this.daemon).priority(this.priority).group(this.group).build();
    }

    public ThreadPoolExecutor build() {
        Parameters.nonNull(this.name, "Name must not null.");
        this.workQueue = Parameters.cleanNull(this.workQueue, LinkedBlockingQueue::new);
        this.handler = Parameters.cleanNull(this.handler, DEFAULT_HANDLER);
        this.threadFactory = Parameters.cleanNull(this.threadFactory, this::generateThreadFactory);
        return new ThreadPoolExecutor(this.coreThreads, this.maximumThreads, this.keepAliveSeconds, TimeUnit.SECONDS, this.workQueue, this.threadFactory, this.handler);
    }

    public ScheduledThreadPoolExecutor buildSchedule() {
        Parameters.nonNull(this.name, "Name must not null.");
        this.handler = Parameters.cleanNull(this.handler, DEFAULT_HANDLER);
        this.threadFactory = Parameters.cleanNull(this.threadFactory, this::generateThreadFactory);
        return new ScheduledThreadPoolExecutor(this.coreThreads, this.threadFactory, this.handler);
    }
}

