/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import io.dingodb.common.CommonId;
import io.dingodb.common.Location;
import io.dingodb.common.config.ClusterConfiguration;
import io.dingodb.common.config.ExchangeConfiguration;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class DingoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DingoConfiguration.class);
    private static DingoConfiguration INSTANCE;
    private ClusterConfiguration cluster;
    private CommonId serverId;
    private ExchangeConfiguration exchange;
    private Map<String, Object> server;
    private Map<String, Object> store;
    private Map<String, Object> net;
    private Map<String, Object> client;
    @JsonIgnore
    private Object serverConfiguration;
    @JsonIgnore
    private Object storeConfiguration;
    @JsonIgnore
    private Object netConfiguration;
    @JsonIgnore
    private Object clientConfiguration;

    public static synchronized <T> T parse(InputStream is, Class<T> clazz) throws IOException {
        YAMLFactory yamlFactory = new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        Object mapper = ((JsonMapper.Builder)JsonMapper.builder(yamlFactory).addModule(new AfterburnerModule())).build();
        ((ObjectMapper)mapper).disable(MapperFeature.AUTO_DETECT_FIELDS);
        ((ObjectMapper)mapper).disable(MapperFeature.AUTO_DETECT_GETTERS);
        ((ObjectMapper)mapper).disable(MapperFeature.AUTO_DETECT_IS_GETTERS);
        ((ObjectMapper)mapper).disable(MapperFeature.AUTO_DETECT_SETTERS);
        ((ObjectMapper)mapper).disable(MapperFeature.AUTO_DETECT_CREATORS);
        ((ObjectMapper)mapper).enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        ((ObjectMapper)mapper).enable(SerializationFeature.INDENT_OUTPUT);
        return ((ObjectMapper)mapper).readValue(is, clazz);
    }

    public static synchronized void parse(String configPath) throws Exception {
        INSTANCE = DingoConfiguration.parse(new FileInputStream(configPath), DingoConfiguration.class);
    }

    public static DingoConfiguration instance() {
        return INSTANCE;
    }

    public static String host() {
        return INSTANCE == null ? null : INSTANCE.getHost();
    }

    public static int port() {
        return INSTANCE == null ? 0 : INSTANCE.getPort();
    }

    public static int raftPort() {
        return INSTANCE == null ? 0 : INSTANCE.getRaftPort();
    }

    public static CommonId serverId() {
        return DingoConfiguration.INSTANCE.serverId;
    }

    public static Location location() {
        return new Location(DingoConfiguration.host(), DingoConfiguration.port(), DingoConfiguration.raftPort());
    }

    public void setServer(Class<?> cls) throws Exception {
        this.serverConfiguration = DingoConfiguration.mapToBean(this.server, cls);
        if (this.serverConfiguration == null) {
            this.serverConfiguration = DingoConfiguration.newInstance(cls);
        }
    }

    public void setStore(Class<?> cls) throws Exception {
        this.storeConfiguration = DingoConfiguration.mapToBean(this.store, cls);
        if (this.storeConfiguration == null) {
            this.storeConfiguration = DingoConfiguration.newInstance(cls);
        }
    }

    public void setNet(Class<?> cls) throws Exception {
        this.netConfiguration = DingoConfiguration.mapToBean(this.net, cls);
        if (this.netConfiguration == null) {
            this.netConfiguration = DingoConfiguration.newInstance(cls);
        }
    }

    public void setClient(Class<?> cls) throws Exception {
        this.clientConfiguration = DingoConfiguration.mapToBean(this.client, cls);
        if (this.clientConfiguration == null) {
            this.clientConfiguration = DingoConfiguration.newInstance(cls);
        }
    }

    public <T> T getServer() {
        return (T)this.serverConfiguration;
    }

    public <T> T getNet() {
        return (T)this.netConfiguration;
    }

    public <T> T getStore() {
        return (T)this.storeConfiguration;
    }

    public int getRaftPort() {
        Object raftPort = ((Map)this.store.get("raft")).get("port");
        if (raftPort == null) {
            log.error("Miss configuration store->raft->port");
            return 0;
        }
        if (raftPort instanceof Integer) {
            return (Integer)raftPort;
        }
        if (raftPort instanceof String) {
            return Integer.parseInt((String)raftPort);
        }
        log.error("Cannot cast raft port");
        return 0;
    }

    public <T> T getClient() {
        return (T)this.clientConfiguration;
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> cls) throws Exception {
        Field[] fields;
        if (map == null) {
            return null;
        }
        T obj = DingoConfiguration.newInstance(cls);
        for (Field field : fields = cls.getDeclaredFields()) {
            try {
                Object value = map.get(field.getName());
                if (value == null) continue;
                if (value instanceof Map && !field.getType().equals(Map.class)) {
                    value = DingoConfiguration.mapToBean((Map)value, field.getType());
                }
                if (!field.getType().equals(value.getClass())) {
                    value = DingoConfiguration.tryConvertValue(value, field.getType());
                }
                field.setAccessible(true);
                field.set(obj, value);
            }
            catch (Exception e) {
                log.error("parse property name: {}. class name: {};", field.getName(), cls.getName(), e);
                throw e;
            }
        }
        return obj;
    }

    @Nonnull
    private static <T> T newInstance(Class<T> cls) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<T> constructor = cls.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        T obj = constructor.newInstance(new Object[0]);
        return obj;
    }

    private static Object tryConvertValue(Object obj, Class<?> type2) {
        String str = obj.toString();
        if (type2.equals(String.class)) {
            return str;
        }
        if (type2.equals(Integer.class)) {
            return Integer.parseInt(str);
        }
        if (type2.equals(Double.class)) {
            return Double.parseDouble(str);
        }
        if (type2.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(str));
        }
        if (type2.equals(Long.class)) {
            return Long.parseLong(str);
        }
        if (type2.equals(Boolean.class)) {
            if (str.matches("[0-1]")) {
                return Integer.parseInt(str) != 0;
            }
            if ("true".equalsIgnoreCase(str)) {
                return true;
            }
            if ("false".equalsIgnoreCase(str)) {
                return false;
            }
        }
        if (type2.equals(byte[].class)) {
            return str.getBytes(StandardCharsets.UTF_8);
        }
        return obj;
    }

    public ClusterConfiguration getCluster() {
        return this.cluster;
    }

    public CommonId getServerId() {
        return this.serverId;
    }

    public ExchangeConfiguration getExchange() {
        return this.exchange;
    }

    public Object getServerConfiguration() {
        return this.serverConfiguration;
    }

    public Object getStoreConfiguration() {
        return this.storeConfiguration;
    }

    public Object getNetConfiguration() {
        return this.netConfiguration;
    }

    public Object getClientConfiguration() {
        return this.clientConfiguration;
    }

    public void setCluster(ClusterConfiguration cluster) {
        this.cluster = cluster;
    }

    public void setServerId(CommonId serverId) {
        this.serverId = serverId;
    }

    public void setExchange(ExchangeConfiguration exchange) {
        this.exchange = exchange;
    }

    @JsonIgnore
    public void setServerConfiguration(Object serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    @JsonIgnore
    public void setStoreConfiguration(Object storeConfiguration) {
        this.storeConfiguration = storeConfiguration;
    }

    @JsonIgnore
    public void setNetConfiguration(Object netConfiguration) {
        this.netConfiguration = netConfiguration;
    }

    @JsonIgnore
    public void setClientConfiguration(Object clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    public String toString() {
        return "DingoConfiguration(cluster=" + this.getCluster() + ", serverId=" + this.getServerId() + ", exchange=" + this.getExchange() + ", server=" + this.getServer() + ", store=" + this.getStore() + ", net=" + this.getNet() + ", client=" + this.getClient() + ", serverConfiguration=" + this.getServerConfiguration() + ", storeConfiguration=" + this.getStoreConfiguration() + ", netConfiguration=" + this.getNetConfiguration() + ", clientConfiguration=" + this.getClientConfiguration() + ")";
    }

    public String getHost() {
        return this.getExchange().getHost();
    }

    public Integer getPort() {
        return this.getExchange().getPort();
    }

    public void setHost(String host) {
        this.getExchange().setHost(host);
    }

    public void setPort(Integer port) {
        this.getExchange().setPort(port);
    }
}

