/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.error;

import io.dingodb.common.error.DingoError;
import io.dingodb.common.error.FormattingError;

public enum CommonError implements FormattingError
{
    EXEC(1001, "Execute error", "Exec %s error, thread: [%s], message: %s."),
    EXEC_INTERRUPT(1002, "Exec interrupted error.", "Exec %s interrupted, thread: [%s], message: [%s]."),
    EXEC_TIMEOUT(1003, "Execute timeout.", "Exec %s timeout, thread: [%s], message: [%s].");

    private final int code;
    private final String info;
    private final String format;

    private CommonError(int code, String info) {
        this.code = code;
        this.info = info;
        this.format = info;
    }

    private CommonError(int code, String info, String format2) {
        this.code = code;
        this.info = info;
        this.format = format2;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public String toString() {
        return DingoError.toString(this);
    }
}

