/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.error;

import io.dingodb.common.error.DerivedError;
import io.dingodb.common.error.DingoException;
import io.dingodb.common.error.ErrorUtil;
import io.dingodb.common.error.NoError;
import io.dingodb.common.error.UnknownError;
import io.dingodb.common.error.WrappedError;
import javax.annotation.Nonnull;

public interface DingoError {
    public static final DingoError OK = NoError.OK;
    public static final DingoError UNKNOWN = UnknownError.UNKNOWN;

    @Nonnull
    public static DingoError from(DingoError err, String message) {
        return new DerivedError(err, message);
    }

    @Nonnull
    public static DingoError from(Throwable throwable) {
        if (throwable instanceof DingoError) {
            return (DingoError)((Object)throwable);
        }
        return DingoError.from(UNKNOWN, throwable.getMessage());
    }

    @Nonnull
    public static DingoError wrap(DingoError err, DingoError reason) {
        return new WrappedError(err, reason);
    }

    public static String toString(DingoError err) {
        return ErrorUtil.toString(err);
    }

    public int getCode();

    public String getInfo();

    default public boolean isOk() {
        return this == OK;
    }

    default public boolean isUnknown() {
        return this.getCategory() == UNKNOWN;
    }

    default public boolean is(DingoError err) {
        return this == err || this.getCategory() == err;
    }

    default public <T extends Enum<T>> boolean is(@Nonnull Class<T> clazz) {
        return clazz.isAssignableFrom(this.getClazz());
    }

    default public <T extends Enum<T>> T as(@Nonnull Class<T> clazz) {
        DingoError category = this.getCategory();
        if (clazz.isAssignableFrom(category.getClass())) {
            return (T)((Enum)((Object)category));
        }
        return null;
    }

    default public DingoError getCategory() {
        return this;
    }

    default public boolean isCategory() {
        return this == this.getCategory();
    }

    default public Class<? extends DingoError> getClazz() {
        return this.getCategory().getClass();
    }

    default public String getMessage() {
        return this.getInfo();
    }

    default public String getDetailMessage() {
        return ErrorUtil.getDetailMessage(this);
    }

    default public DingoError getReason() {
        return OK;
    }

    default public DingoError degrade() {
        if (this.getMessage() == this.getCategory().getMessage()) {
            return this.getCategory();
        }
        return DingoError.from(this.getCategory(), this.getMessage());
    }

    default public void throwError() {
        if (this.getCode() == NoError.OK.getCode()) {
            return;
        }
        throw DingoException.from(this);
    }

    default public DingoException asException() {
        return this.asException(null);
    }

    default public DingoException asException(String message) {
        if (message == null) {
            return DingoException.from(this);
        }
        return DingoException.from(this, message);
    }
}

