/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.error;

import io.dingodb.common.error.DingoError;
import io.dingodb.common.error.IndirectError;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class DingoException
extends RuntimeException
implements IndirectError {
    public static Integer OBJECT_NOT_FOUND = 90002;
    public static Integer INSERT_NULL_TO_NON_NULL_COLUMN = 90003;
    public static Integer INSERT_NULL_POINTER = 90004;
    public static Integer TYPE_CAST_ERROR = 90005;
    public static Integer TABLE_ALREADY_EXISTS = 90007;
    public static Integer DUPLICATED_COLUMN = 90009;
    public static Integer PRIMARY_KEY_REQUIRED = 90010;
    public static Integer ASSIGNED_MORE_THAN_ONCE = 90011;
    public static Integer INSERT_COLUMN_NUMBER_NOT_EQUAL = 90013;
    public static Integer JOIN_NAME_DUPLICATED = 90015;
    public static Integer JOIN_NO_CONDITION = 90016;
    public static Integer JOIN_SELECT_COLUMN_AMBIGUOUS = 90017;
    public static Integer INTERPRET_ERROR = 90019;
    public static Integer FUNCTION_NOT_SUPPORT = 90022;
    public static Integer EXECUTOR_NODE_FAIL = 90024;
    public static HashMap<Pattern, Integer> CALCITE_CONTEXT_EXCEPTION_PATTERN_CODE_MAP = new HashMap();
    public static HashMap<Pattern, Integer> RUNTIME_EXCEPTION_PATTERN_CODE_MAP;
    private static final long serialVersionUID = 5564571207617481306L;
    private final DingoError category;
    private final DingoError reason;

    private DingoException(DingoError err, String message) {
        this(err, OK, message);
    }

    private DingoException(DingoError err, DingoError reason) {
        this(err, reason, err.getMessage());
    }

    private DingoException(@Nonnull DingoError err, DingoError reason, String message) {
        super(message);
        this.category = err.getCategory();
        this.reason = reason;
    }

    @Nonnull
    public static DingoException from(DingoError err) {
        if (err instanceof DingoException) {
            return (DingoException)err;
        }
        return DingoException.from(err, err.getMessage());
    }

    @Nonnull
    public static DingoException from(DingoError err, String message) {
        return new DingoException(err, message);
    }

    @Nonnull
    public static DingoException from(Throwable throwable) {
        if (throwable instanceof DingoException) {
            return (DingoException)throwable;
        }
        DingoException ex = new DingoException(UNKNOWN, throwable.getMessage());
        ex.initCause(throwable);
        return ex;
    }

    @Nonnull
    public static DingoException wrap(DingoError err, DingoError reason) {
        if (reason instanceof Throwable) {
            return DingoException.wrap(err, (Throwable)((Object)reason));
        }
        return new DingoException(err, reason);
    }

    @Nonnull
    public static DingoException wrap(DingoError err, Throwable reason) {
        DingoException ex = new DingoException(err, DingoError.from(reason));
        ex.initCause(reason);
        return ex;
    }

    @Nonnull
    public static DingoException wrap(DingoError err, DingoException reason) {
        return DingoException.wrap(err, (Throwable)reason);
    }

    @Override
    public DingoError getCategory() {
        return this.category;
    }

    @Override
    public DingoError getReason() {
        return this.reason;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return super.getStackTrace();
    }

    static {
        CALCITE_CONTEXT_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Object .* not found"), OBJECT_NOT_FOUND);
        CALCITE_CONTEXT_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Table .* already exists"), TABLE_ALREADY_EXISTS);
        CALCITE_CONTEXT_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Unknown target column.*"), OBJECT_NOT_FOUND);
        CALCITE_CONTEXT_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Column .* not found in any table"), OBJECT_NOT_FOUND);
        CALCITE_CONTEXT_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Target column .* is assigned more than once"), ASSIGNED_MORE_THAN_ONCE);
        CALCITE_CONTEXT_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Number of INSERT target columns \\(.*\\) does not equal number"), INSERT_COLUMN_NUMBER_NOT_EQUAL);
        CALCITE_CONTEXT_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("No match found for function signature"), FUNCTION_NOT_SUPPORT);
        CALCITE_CONTEXT_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile(" Duplicate relation name"), JOIN_NAME_DUPLICATED);
        CALCITE_CONTEXT_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("INNER, LEFT, RIGHT or FULL join requires a condition"), JOIN_NO_CONDITION);
        CALCITE_CONTEXT_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Column .* is ambiguous"), JOIN_SELECT_COLUMN_AMBIGUOUS);
        RUNTIME_EXCEPTION_PATTERN_CODE_MAP = new HashMap();
        RUNTIME_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Table .* already exists"), TABLE_ALREADY_EXISTS);
        RUNTIME_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Column .* has no default value and does not allow NULLs"), INSERT_NULL_TO_NON_NULL_COLUMN);
        RUNTIME_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Duplicate column names"), DUPLICATED_COLUMN);
        RUNTIME_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Primary keys are required"), PRIMARY_KEY_REQUIRED);
        RUNTIME_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("java\\.lang\\.NullPointerException: null"), INSERT_NULL_POINTER);
        RUNTIME_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile(".* does not match"), INTERPRET_ERROR);
        RUNTIME_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile(".* to time/date/datetime"), INTERPRET_ERROR);
        RUNTIME_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Error while applying rule DingoValuesReduceRule"), INTERPRET_ERROR);
        RUNTIME_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("exception\\.FailGetEvaluator"), TYPE_CAST_ERROR);
        RUNTIME_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("exceeds max .* or lower min value"), TYPE_CAST_ERROR);
        RUNTIME_EXCEPTION_PATTERN_CODE_MAP.put(Pattern.compile("Table meta save success, but schedule failed"), EXECUTOR_NODE_FAIL);
    }
}

