/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.error;

import io.dingodb.common.error.DingoError;
import io.dingodb.common.error.FormattingError;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class ErrorUtil {
    private ErrorUtil() {
    }

    static String getDetailMessage(@Nonnull DingoError err) {
        DingoError reason = err.getReason();
        if (reason.isOk()) {
            return err.getMessage();
        }
        StringBuilder builder = new StringBuilder(err.getMessage());
        do {
            builder.append(". Caused by\n");
            builder.append(reason.getMessage());
        } while (!(reason = reason.getReason()).isOk());
        return builder.toString();
    }

    @Nullable
    static String format(@Nonnull FormattingError err, Object ... args) {
        String fmt = err.getFormat();
        if (args.length == 0 && fmt == null) {
            return null;
        }
        if (fmt == null) {
            return String.format("No formation for error type %s", err.getClass().getCanonicalName());
        }
        return String.format(fmt, args);
    }

    static String toString(@Nonnull DingoError err) {
        String className = err.getClazz().getCanonicalName();
        if (err.isCategory()) {
            return String.format("error class: %s, code: %s, info: %s", className, err.getCode(), err.getInfo());
        }
        return String.format("error class: %s, code: %d, info: %s, message: %s", className, err.getCode(), err.getInfo(), err.getMessage());
    }
}

