/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.error;

import io.dingodb.common.error.DingoError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ExceptionInfo {
    private final String name;
    private final String message;
    private final List<String> stacktrace;

    private ExceptionInfo(String name, String message, List<String> stacktrace) {
        this.name = name;
        this.message = message;
        this.stacktrace = stacktrace;
    }

    @Nonnull
    public static ExceptionInfo fromThrowable(Throwable throwable) {
        String name = ExceptionInfo.buildExceptionName(throwable);
        List<String> stacktrace = ExceptionInfo.buildExceptionStacktrace(throwable);
        return new ExceptionInfo(name, throwable.getMessage(), stacktrace);
    }

    @Nonnull
    public static List<ExceptionInfo> buildExceptionChain(Throwable throwable) {
        ArrayList<ExceptionInfo> chain = new ArrayList<ExceptionInfo>();
        do {
            chain.add(ExceptionInfo.fromThrowable(throwable));
        } while ((throwable = throwable.getCause()) != null);
        return Collections.unmodifiableList(chain);
    }

    private static String buildExceptionName(Throwable throwable) {
        if (throwable instanceof DingoError) {
            DingoError err = (DingoError)((Object)throwable);
            return String.format("%s[%s]", throwable.getClass().getName(), err.getClazz().getName());
        }
        return throwable.getClass().getCanonicalName();
    }

    @Nonnull
    private static List<String> buildExceptionStacktrace(@Nonnull Throwable throwable) {
        ArrayList<String> stacktrace = new ArrayList<String>();
        for (StackTraceElement element : throwable.getStackTrace()) {
            String stack = String.format("%s.%s at %s:%d", element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber());
            stacktrace.add(stack);
        }
        return stacktrace;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getStacktrace() {
        return this.stacktrace;
    }
}

