/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.hash;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dingodb.common.hash.HashStrategy;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonTypeName(value="simple")
public final class SimpleHashStrategy
implements HashStrategy {
    private int outputNum;

    @Override
    public int selectOutput(@Nonnull Object[] tuple) {
        int hash = Objects.hash(tuple);
        int index = hash % this.outputNum;
        return index >= 0 ? index : index + this.outputNum;
    }

    @Nonnull
    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void setOutputNum(int outputNum) {
        this.outputNum = outputNum;
    }
}

