/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.metrics;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jmx.JmxReporter;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class DingoMetrics {
    private static final MetricRegistry metricRegistry = new MetricRegistry();

    public static Meter meter(@Nonnull String name) {
        return metricRegistry.meter(name);
    }

    private static Timer timer(@Nonnull String name) {
        return metricRegistry.timer(name);
    }

    public static Timer.Context getTimeContext(@Nonnull String name) {
        return DingoMetrics.timer(name).time();
    }

    public static void latency(@Nonnull String name, long durationMs) {
        metricRegistry.timer(name).update(durationMs, TimeUnit.MILLISECONDS);
    }

    public static void histogram(@Nonnull String name, long size) {
        metricRegistry.histogram(name).update(size);
    }

    static {
        JmxReporter jmxReporter = JmxReporter.forRegistry(metricRegistry).build();
        jmxReporter.start();
    }
}

