/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation;

import io.dingodb.common.operation.Column;
import io.dingodb.common.operation.DingoExecResult;
import io.dingodb.common.operation.Value;
import io.dingodb.common.operation.compute.CollectionType;
import io.dingodb.common.operation.context.ListContext;
import io.dingodb.common.operation.context.MapContext;
import io.dingodb.common.operation.context.OperationContext;
import io.dingodb.common.operation.context.UniqueListContext;
import io.dingodb.common.operation.executive.Executive;
import io.dingodb.common.store.KeyValue;
import io.dingodb.common.type.converter.ClientConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CollectionOperation<D extends OperationContext, T, R>
extends Executive<D, T, R> {
    default public String arrayToString(Object[] keys) {
        return String.join((CharSequence)",", (CharSequence[])Arrays.stream(keys).map(Object::toString).toArray(String[]::new));
    }

    default public Object convertValueTo(Object value) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            byte[] result = bos.toByteArray();
            oos.close();
            bos.close();
            return ClientConverter.INSTANCE.convert(result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    default public Map<?, ?> convertValueFrom(Object value) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(ClientConverter.INSTANCE.convertBinaryFrom(value));
            ObjectInputStream ois = new ObjectInputStream(bis);
            Map result = (Map)ois.readObject();
            ois.close();
            bis.close();
            return result;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static class RemoveByValue
    implements CollectionOperation<UniqueListContext, Iterator<KeyValue>, Object> {
        private static final Logger log = LoggerFactory.getLogger(RemoveByValue.class);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public List<KeyValue> execute(UniqueListContext context, Iterator<KeyValue> records) {
            ArrayList<KeyValue> list = new ArrayList<KeyValue>();
            try {
                Column[] columns = context.columns;
                int[] indexes = new int[columns.length];
                for (int i = 0; i < columns.length; ++i) {
                    indexes[i] = context.definition.getColumnIndexOfValue(columns[i].name);
                }
                while (records.hasNext()) {
                    KeyValue keyValue = records.next();
                    try {
                        Object[] objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes);
                        for (int i = 0; i < objects.length; ++i) {
                            CopyOnWriteArrayList value = new CopyOnWriteArrayList((List)objects[i]);
                            for (Object v : value) {
                                if (!v.equals(context.value.getObject())) continue;
                                value.remove(v);
                            }
                            objects[i] = value;
                        }
                        byte[] bytes = context.dingoValueCodec().encode(keyValue.getValue(), objects, indexes);
                        keyValue.setValue(bytes);
                        list.add(keyValue);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                        return list;
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to delete element based on value", e);
            }
            return list;
        }
    }

    public static class GetByValue
    implements CollectionOperation<UniqueListContext, Iterator<KeyValue>, Object> {
        @Override
        public DingoExecResult execute(UniqueListContext context, Iterator<KeyValue> records) {
            HashMap<String, Value> result = new HashMap<String, Value>();
            Column[] columns = context.columns;
            int[] indexes = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                indexes[i] = context.definition.getColumnIndexOfValue(columns[i].name);
            }
            while (records.hasNext()) {
                KeyValue keyValue = records.next();
                try {
                    HashMap values = new HashMap();
                    Object[] objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes);
                    for (int i = 0; i < objects.length; ++i) {
                        List value = ((List)objects[i]).stream().filter(l -> l.equals(context.value.getObject())).collect(Collectors.toList());
                        values.put(columns[i].name, value);
                    }
                    Object[] key = context.keyValueCodec().decodeKey(keyValue.getKey());
                    result.put(this.arrayToString(key), Value.get(values));
                }
                catch (IOException e) {
                    return new DingoExecResult(false, "Get by value operation decode failed, " + e.getMessage());
                }
            }
            return new DingoExecResult(result, true, "OK", CollectionType.GET_BY_VALUE.name());
        }
    }

    public static class GetByKey
    implements CollectionOperation<MapContext, Iterator<KeyValue>, Object> {
        private static final Logger log = LoggerFactory.getLogger(GetByKey.class);

        @Override
        public DingoExecResult execute(MapContext context, Iterator<KeyValue> records) {
            HashMap<String, Value> result = new HashMap<String, Value>();
            Column[] columns = context.columns;
            int[] indexes = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                indexes[i] = context.definition.getColumnIndexOfValue(columns[i].name);
            }
            while (records.hasNext()) {
                KeyValue keyValue = records.next();
                try {
                    Object[] objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes);
                    HashMap values = new HashMap();
                    for (int i = 0; i < objects.length; ++i) {
                        Map<?, ?> value = this.convertValueFrom(objects[i]);
                        if (!value.containsKey(context.key.getObject())) continue;
                        values.put(columns[i].name, value.get(context.key.getObject()));
                    }
                    if (!values.isEmpty()) {
                        Object[] key = context.keyValueCodec().decodeKey(keyValue.getKey());
                        result.put(this.arrayToString(key), Value.get(values));
                        continue;
                    }
                    log.info("Collection get by key operation, The key:{} was not found in the map", context.key.getObject());
                }
                catch (IOException e) {
                    return new DingoExecResult(false, "Get by key operation decode failed, " + e.getMessage());
                }
            }
            return new DingoExecResult(result, true, "OK", CollectionType.GET_BY_KEY.name());
        }
    }

    public static class RemoveByKey
    implements CollectionOperation<MapContext, Iterator<KeyValue>, Object> {
        private static final Logger log = LoggerFactory.getLogger(RemoveByKey.class);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public List<KeyValue> execute(MapContext context, Iterator<KeyValue> records) {
            ArrayList<KeyValue> list = new ArrayList<KeyValue>();
            try {
                Column[] columns = context.columns;
                int[] indexes = new int[columns.length];
                for (int i = 0; i < columns.length; ++i) {
                    indexes[i] = context.definition.getColumnIndexOfValue(columns[i].name);
                }
                while (records.hasNext()) {
                    KeyValue keyValue = records.next();
                    try {
                        Object[] objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes);
                        for (int i = 0; i < objects.length; ++i) {
                            Map<?, ?> value = this.convertValueFrom(objects[i]);
                            value.remove(context.key.getObject());
                            objects[i] = this.convertValueTo(value);
                        }
                        byte[] bytes = context.dingoValueCodec().encode(keyValue.getValue(), objects, indexes);
                        keyValue.setValue(bytes);
                        list.add(keyValue);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                        return list;
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to delete element based on key", e);
            }
            return list;
        }
    }

    public static class Put
    implements CollectionOperation<MapContext, Iterator<KeyValue>, Object> {
        private static final Logger log = LoggerFactory.getLogger(Put.class);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public List<KeyValue> execute(MapContext context, Iterator<KeyValue> records) {
            ArrayList<KeyValue> list = new ArrayList<KeyValue>();
            try {
                Column[] columns = context.columns;
                int[] indexes = new int[columns.length];
                for (int i = 0; i < columns.length; ++i) {
                    indexes[i] = context.definition.getColumnIndexOfValue(columns[i].name);
                }
                while (records.hasNext()) {
                    KeyValue keyValue = records.next();
                    try {
                        Object[] objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes);
                        for (int i = 0; i < objects.length; ++i) {
                            Map<?, ?> value = this.convertValueFrom(objects[i]);
                            value.put(context.key.getObject(), context.value.getObject());
                            objects[i] = this.convertValueTo(value);
                        }
                        byte[] bytes = context.dingoValueCodec().encode(keyValue.getValue(), objects, indexes);
                        keyValue.setValue(bytes);
                        list.add(keyValue);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                        return list;
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to add element to collection", e);
            }
            return list;
        }
    }

    public static class RemoveByIndex
    implements CollectionOperation<ListContext, Iterator<KeyValue>, Object> {
        private static final Logger log = LoggerFactory.getLogger(RemoveByIndex.class);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public List<KeyValue> execute(ListContext context, Iterator<KeyValue> records) {
            ArrayList<KeyValue> list = new ArrayList<KeyValue>();
            try {
                Column[] columns = context.columns;
                int[] indexes = new int[columns.length];
                for (int i = 0; i < columns.length; ++i) {
                    indexes[i] = context.definition.getColumnIndexOfValue(columns[i].name);
                }
                while (records.hasNext()) {
                    KeyValue keyValue = records.next();
                    try {
                        Object[] objects;
                        for (Object object : objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes)) {
                            List value = (List)object;
                            if (value.size() <= context.index) continue;
                            value.remove(context.index);
                        }
                        byte[] bytes = context.dingoValueCodec().encode(keyValue.getValue(), objects, indexes);
                        keyValue.setValue(bytes);
                        list.add(keyValue);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                        return list;
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to remove element based on index", e);
            }
            return list;
        }
    }

    public static class Clear
    implements CollectionOperation<OperationContext, Iterator<KeyValue>, Object> {
        private static final Logger log = LoggerFactory.getLogger(Clear.class);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public List<KeyValue> execute(OperationContext context, Iterator<KeyValue> records) {
            ArrayList<KeyValue> list = new ArrayList<KeyValue>();
            try {
                Column[] columns = context.columns;
                int[] indexes = new int[columns.length];
                for (int i = 0; i < columns.length; ++i) {
                    indexes[i] = context.definition.getColumnIndexOfValue(columns[i].name);
                }
                while (records.hasNext()) {
                    KeyValue keyValue = records.next();
                    try {
                        Object[] objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes);
                        Object[] convertObj = this.convert(objects);
                        byte[] bytes = context.dingoValueCodec().encode(keyValue.getValue(), convertObj, indexes);
                        keyValue.setValue(bytes);
                        list.add(keyValue);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                        return list;
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to clear collection", e);
            }
            return list;
        }

        private Object[] convert(Object[] objects) {
            for (int i = 0; i < objects.length; ++i) {
                Object object = objects[i];
                if (object instanceof List) {
                    List list = (List)object;
                    list.clear();
                    objects[i] = list;
                    continue;
                }
                if (!(object instanceof byte[])) continue;
                Map<?, ?> map = this.convertValueFrom(object);
                map.clear();
                objects[i] = this.convertValueTo(map);
            }
            return objects;
        }
    }

    public static class Set
    implements CollectionOperation<ListContext, Iterator<KeyValue>, Object> {
        @Override
        public List<KeyValue> execute(ListContext context, Iterator<KeyValue> records) {
            ArrayList<KeyValue> list = new ArrayList<KeyValue>();
            Column[] columns = context.columns;
            int[] indexes = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                indexes[i] = context.definition.getColumnIndexOfValue(columns[i].name);
            }
            while (records.hasNext()) {
                KeyValue keyValue = records.next();
                try {
                    Object[] objects;
                    for (Object object : objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes)) {
                        List value = (List)object;
                        value.add(context.value.getObject());
                    }
                    byte[] bytes = context.dingoValueCodec().encode(keyValue.getValue(), objects, indexes);
                    keyValue.setValue(bytes);
                    list.add(keyValue);
                }
                catch (IOException e) {
                    throw new RuntimeException();
                }
            }
            return list;
        }
    }

    public static class GetAll
    implements CollectionOperation<OperationContext, Iterator<KeyValue>, Object> {
        @Override
        public DingoExecResult execute(OperationContext context, Iterator<KeyValue> records) {
            HashMap<String, Value> result = new HashMap<String, Value>();
            Column[] columns = context.columns;
            int[] indexes = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                indexes[i] = context.definition.getColumnIndexOfValue(columns[i].name);
            }
            while (records.hasNext()) {
                KeyValue keyValue = records.next();
                try {
                    Object[] objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes);
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    for (int i = 0; i < objects.length; ++i) {
                        values.put(columns[i].name, this.convert(objects[i]));
                    }
                    Object[] key = context.keyValueCodec().decodeKey(keyValue.getKey());
                    result.put(this.arrayToString(key), Value.get(values));
                }
                catch (IOException e) {
                    return new DingoExecResult(false, "Get all operation decode failed, " + e.getMessage());
                }
            }
            return new DingoExecResult(result, true, "OK", CollectionType.GET_ALL.name());
        }

        private Object convert(Object object) {
            if (object instanceof byte[]) {
                return this.convertValueFrom(object);
            }
            return object;
        }
    }

    public static class GetByIndexRange
    implements CollectionOperation<ListContext, Iterator<KeyValue>, Object> {
        @Override
        public DingoExecResult execute(ListContext context, Iterator<KeyValue> records) {
            HashMap<String, Value> result = new HashMap<String, Value>();
            Column[] columns = context.columns;
            int[] indexes = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                indexes[i] = context.definition.getColumnIndexOfValue(columns[i].name);
            }
            while (records.hasNext()) {
                KeyValue keyValue = records.next();
                try {
                    Object[] objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes);
                    HashMap values = new HashMap();
                    for (int i = 0; i < objects.length; ++i) {
                        List list = (List)objects[i];
                        int fromIndex = context.index;
                        int toIndex = Math.min(fromIndex + context.count, list.size());
                        ArrayList value = fromIndex < 0 || fromIndex > toIndex ? new ArrayList() : new ArrayList(list.subList(fromIndex, toIndex));
                        values.put(columns[i].name, value);
                    }
                    Object[] key = context.keyValueCodec().decodeKey(keyValue.getKey());
                    result.put(this.arrayToString(key), Value.get(values));
                }
                catch (IOException e) {
                    return new DingoExecResult(false, "Get by index range operation decode failed, " + e.getMessage());
                }
            }
            return new DingoExecResult(result, true, "OK", CollectionType.GET_BY_INDEX_RANGE.name());
        }
    }

    public static class GetByIndex
    implements CollectionOperation<ListContext, Iterator<KeyValue>, Object> {
        @Override
        public DingoExecResult execute(ListContext context, Iterator<KeyValue> records) {
            HashMap<String, Value> result = new HashMap<String, Value>();
            Column[] columns = context.columns;
            int[] indexes = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                indexes[i] = context.definition.getColumnIndexOfValue(columns[i].name);
            }
            while (records.hasNext()) {
                KeyValue keyValue = records.next();
                try {
                    Object[] objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes);
                    HashMap values = new HashMap();
                    for (int i = 0; i < objects.length; ++i) {
                        List value = (List)objects[i];
                        if (value.size() <= context.index) continue;
                        values.put(columns[i].name, value.get(context.index));
                    }
                    Object[] key = context.keyValueCodec().decodeKey(keyValue.getKey());
                    result.put(this.arrayToString(key), Value.get(values));
                }
                catch (IOException e) {
                    return new DingoExecResult(false, "Get by index operation decode failed, " + e.getMessage());
                }
            }
            return new DingoExecResult(result, true, "OK", CollectionType.GET_BY_INDEX.name());
        }
    }

    public static class Size
    implements CollectionOperation<OperationContext, Iterator<KeyValue>, Object> {
        private static final Logger log = LoggerFactory.getLogger(Size.class);

        @Override
        public DingoExecResult execute(OperationContext context, Iterator<KeyValue> records) {
            HashMap<String, Value> result = new HashMap<String, Value>();
            Column[] columns = context.columns;
            int[] indexes = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                indexes[i] = context.definition.getColumnIndexOfValue(columns[i].name);
            }
            while (records.hasNext()) {
                KeyValue keyValue = records.next();
                try {
                    Object[] objects = context.dingoValueCodec().decode(keyValue.getValue(), indexes);
                    Map<String, Object> values = this.getCollectionSize(columns, objects);
                    Object[] key = context.keyValueCodec().decodeKey(keyValue.getKey());
                    result.put(this.arrayToString(key), Value.get(values));
                }
                catch (IOException e) {
                    return new DingoExecResult(false, "Size operation decode failed, " + e.getMessage());
                }
            }
            return new DingoExecResult(result, true, "OK", CollectionType.SIZE.name());
        }

        private Map<String, Object> getCollectionSize(Column[] columns, Object[] objects) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (int i = 0; i < objects.length; ++i) {
                int size;
                if (objects[i] instanceof List) {
                    List list = (List)objects[i];
                    size = list.size();
                } else if (objects[i] instanceof byte[]) {
                    Map<?, ?> map = this.convertValueFrom(objects[i]);
                    size = map.size();
                } else {
                    size = 0;
                }
                values.put(columns[i].name, size);
            }
            return values;
        }
    }
}

