/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation;

import io.dingodb.common.operation.MapOrder;
import io.dingodb.common.operation.Value;
import java.util.List;
import java.util.Map;

public final class Column {
    public final String name;
    public final Value value;

    public Column(String name) {
        this.name = name;
        this.value = Value.getAsNull();
    }

    public Column(String name, String value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Column(String name, byte[] value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Column(String name, byte[] value, int type2) {
        this.name = name;
        this.value = Value.get(value, type2);
    }

    public Column(String name, byte[] value, int offset, int length) {
        this.name = name;
        this.value = Value.get(value, offset, length);
    }

    public Column(String name, byte value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Column(String name, int value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Column(String name, long value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Column(String name, double value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Column(String name, float value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Column(String name, boolean value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Column(String name, List<?> value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Column(String name, Map<?, ?> value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public Column(String name, Map<?, ?> value, MapOrder mapOrder) {
        this.name = name;
        this.value = Value.get(value, mapOrder);
    }

    public Column(String name, List<? extends Map.Entry<?, ?>> value, MapOrder mapOrder) {
        this.name = name;
        this.value = Value.get(value, mapOrder);
    }

    public Column(String name, Value value) {
        this.name = name;
        this.value = value;
    }

    public Column(String name, Object value) {
        this.name = name;
        this.value = Value.get(value);
    }

    public static Column asBlob(String name, Object value) {
        return new Column(name, Value.getAsBlob(value));
    }

    public static Column asNull(String name) {
        return new Column(name, Value.getAsNull());
    }

    public String toString() {
        return this.name + ':' + this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }
}

