/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation;

import io.dingodb.common.operation.Value;
import java.io.Serializable;
import java.util.Map;

public class DingoExecResult
implements Serializable {
    private static final long serialVersionUID = -5528925734091175454L;
    private Map<String, Value> record;
    private boolean isSuccess;
    private String errorMessage;
    private String op;

    public DingoExecResult(boolean isSuccess, String errorMessage) {
        this(null, isSuccess, errorMessage, null);
    }

    public DingoExecResult(Map<String, Value> record, boolean isSuccess, String errorMessage, String op) {
        this.record = record;
        this.isSuccess = isSuccess;
        this.errorMessage = errorMessage;
        this.op = op;
    }

    public Map<String, Value> getRecord() {
        return this.record;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String op() {
        return this.op;
    }

    public Value get(String key, String column) {
        Value mapValue = this.record.get(key);
        if (mapValue.getType() == 19) {
            Map map = (Map)mapValue.getObject();
            return Value.get(map.get(column));
        }
        return mapValue;
    }

    public Value get(String column) {
        return this.record.get(column.toUpperCase());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(500);
        sb.append('{');
        sb.append("record: ");
        if (this.record != null) {
            boolean sep = false;
            for (Map.Entry<String, Value> entry : this.record.entrySet()) {
                if (sep) {
                    sb.append(',');
                } else {
                    sep = true;
                }
                sb.append('{');
                sb.append(entry.getKey());
                sb.append(": ");
                if (entry.getValue().getType() == 19) {
                    Map map = (Map)entry.getValue().getObject();
                    sb.append('{');
                    boolean b = false;
                    for (Map.Entry mapEntry : map.entrySet()) {
                        if (b) {
                            sb.append(',');
                        } else {
                            b = true;
                        }
                        sb.append((String)mapEntry.getKey());
                        sb.append(':');
                        sb.append(mapEntry.getValue());
                    }
                    sb.append('}');
                } else {
                    sb.append(':');
                    sb.append(entry.getValue().getObject());
                    sb.append('}');
                }
                if (sb.length() <= 1000) continue;
                sb.append("...");
                break;
            }
            sb.append('}');
        } else {
            sb.append("null");
        }
        sb.append(',');
        sb.append("isSuccess: ");
        sb.append(this.isSuccess);
        sb.append(", ");
        sb.append("errorMessage: ");
        sb.append('\"');
        sb.append(this.errorMessage);
        sb.append('\"');
        sb.append(", ");
        sb.append("op: ");
        if (this.op == null) {
            sb.append("null");
        } else {
            sb.append('\"');
            sb.append(this.op);
            sb.append('\"');
        }
        sb.append('}');
        return sb.toString();
    }
}

