/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation;

import io.dingodb.common.operation.Column;
import io.dingodb.common.operation.Operation;
import io.dingodb.common.operation.Value;
import io.dingodb.common.operation.compute.CollectionType;
import io.dingodb.common.operation.context.ListContext;

public final class ListOperation {
    public static Operation size(Column column) {
        return new Operation(CollectionType.SIZE, new ListContext(column));
    }

    public static Operation clear(Column column) {
        return new Operation(CollectionType.CLEAR, new ListContext(column));
    }

    public static Operation set(int index, Value value, Column column) {
        ListContext context = new ListContext(index, value, column);
        return new Operation(CollectionType.SET, context);
    }

    public static Operation getAll(Column column) {
        return new Operation(CollectionType.GET_ALL, new ListContext(column));
    }

    public static Operation getByIndex(int index, Column column) {
        ListContext context = new ListContext(index, column);
        return new Operation(CollectionType.GET_BY_INDEX, context);
    }

    public static Operation getByIndexRange(int index, int count, Column column) {
        ListContext context = new ListContext(index, count, column);
        return new Operation(CollectionType.GET_BY_INDEX_RANGE, context);
    }

    public static Operation remove(int index, Column column) {
        ListContext context = new ListContext(index, column);
        return new Operation(CollectionType.REMOVE_BY_INDEX, context);
    }
}

