/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation;

import io.dingodb.common.operation.Column;
import io.dingodb.common.operation.OperationType;
import io.dingodb.common.operation.compute.BasicType;
import io.dingodb.common.operation.compute.NumericType;
import io.dingodb.common.operation.context.BasicContext;
import io.dingodb.common.operation.context.OperationContext;
import java.io.Serializable;

public final class Operation
implements Serializable {
    private static final long serialVersionUID = 8603290191302531535L;
    public final OperationType operationType;
    public final OperationContext operationContext;

    public Operation(OperationType operationType, OperationContext operationContext) {
        this.operationType = operationType;
        this.operationContext = operationContext;
    }

    public static Operation add(boolean useDefaultWhenNotExisted, Column ... columns) {
        return new Operation(NumericType.ADD, new BasicContext(useDefaultWhenNotExisted, columns));
    }

    public static Operation max(Column ... columns) {
        return new Operation(NumericType.MAX, new BasicContext(columns));
    }

    public static Operation min(Column ... columns) {
        return new Operation(NumericType.MIN, new BasicContext(columns));
    }

    public static Operation sum(Column ... columns) {
        return new Operation(NumericType.SUM, new BasicContext(columns));
    }

    public static Operation count(Column ... columns) {
        return new Operation(NumericType.COUNT, new BasicContext(columns));
    }

    public static Operation update(Column ... columns) {
        return new Operation(BasicType.UPDATE, new BasicContext(columns));
    }
}

