/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation;

import io.dingodb.common.operation.MapOrder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.UUID;

public abstract class Value {
    public static boolean UseBoolBin = false;
    public static final Value NULL = NullValue.INSTANCE;
    public static final Value INFINITY = new InfinityValue();

    public static Value get(String value) {
        return value == null ? NullValue.INSTANCE : new StringValue(value);
    }

    public static Value get(byte[] value) {
        return value == null ? NullValue.INSTANCE : new BytesValue(value);
    }

    public static Value get(byte[] value, int type2) {
        return value == null ? NullValue.INSTANCE : new BytesValue(value, type2);
    }

    public static Value get(byte[] value, int offset, int length) {
        return value == null ? NullValue.INSTANCE : new ByteSegmentValue(value, offset, length);
    }

    public static Value get(ByteBuffer bb) {
        return bb == null ? NullValue.INSTANCE : new BytesValue(bb.array());
    }

    public static Value get(byte value) {
        return new ByteValue(value);
    }

    public static Value get(int value) {
        return new IntegerValue(value);
    }

    public static Value get(long value) {
        return new LongValue(value);
    }

    public static Value get(double value) {
        return new DoubleValue(value);
    }

    public static Value get(float value) {
        return new FloatValue(value);
    }

    public static Value get(boolean value) {
        if (UseBoolBin) {
            return new BooleanValue(value);
        }
        return new BoolIntValue(value);
    }

    public static Value get(Enum<?> value) {
        return value == null ? NullValue.INSTANCE : new StringValue(value.toString());
    }

    public static Value get(UUID value) {
        return value == null ? NullValue.INSTANCE : new StringValue(value.toString());
    }

    public static Value get(List<?> value) {
        return value == null ? NullValue.INSTANCE : new ListValue(value);
    }

    public static Value get(Map<?, ?> value) {
        return value == null ? NullValue.INSTANCE : new MapValue(value);
    }

    public static Value get(Map<?, ?> value, MapOrder order) {
        return value == null ? NullValue.INSTANCE : new MapValue(value, order);
    }

    public static Value get(List<? extends Map.Entry<?, ?>> value, MapOrder mapOrder) {
        return value == null ? NullValue.INSTANCE : new SortedMapValue(value, mapOrder);
    }

    public static Value get(Value[] value) {
        return value == null ? NullValue.INSTANCE : new ValueArray(value);
    }

    public static Value get(Object value) {
        if (value == null) {
            return NullValue.INSTANCE;
        }
        if (value instanceof Value) {
            return (Value)value;
        }
        if (value instanceof byte[]) {
            return new BytesValue((byte[])value);
        }
        if (value instanceof String) {
            return new StringValue((String)value);
        }
        if (value instanceof Integer) {
            return new IntegerValue((Integer)value);
        }
        if (value instanceof Long) {
            return new LongValue((Long)value);
        }
        if (value instanceof Double) {
            return new DoubleValue((Double)value);
        }
        if (value instanceof Float) {
            return new FloatValue(((Float)value).floatValue());
        }
        if (value instanceof Boolean) {
            if (UseBoolBin) {
                return new BooleanValue((Boolean)value);
            }
            return new BoolIntValue((Boolean)value);
        }
        if (value instanceof Byte) {
            return new ByteValue((Byte)value);
        }
        if (value instanceof Enum) {
            return new StringValue(value.toString());
        }
        if (value instanceof UUID) {
            return new StringValue(value.toString());
        }
        if (value instanceof List) {
            return new ListValue((List)value);
        }
        if (value instanceof Map) {
            return new MapValue((Map)value);
        }
        if (value instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)value;
            return new BytesValue(bb.array());
        }
        return new BlobValue(value);
    }

    public static Value getAsBlob(Object value) {
        return value == null ? NullValue.INSTANCE : new BlobValue(value);
    }

    public static Value getAsNull() {
        return NullValue.INSTANCE;
    }

    @Deprecated
    public static Value getFromRecordObject(Object value) {
        return Value.get(value);
    }

    public void validateKeyType() {
    }

    public abstract int getType();

    public abstract Object getObject();

    public Number value() {
        return null;
    }

    public static String bytesToHexString(byte[] buf) {
        if (buf == null || buf.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            sb.append(String.format("%02x", buf[i]));
        }
        return sb.toString();
    }

    public static String bytesToHexString(byte[] buf, int offset, int length) {
        StringBuilder sb = new StringBuilder(length * 2);
        for (int i = offset; i < length; ++i) {
            sb.append(String.format("%02x", buf[i]));
        }
        return sb.toString();
    }

    public static final class InfinityValue
    extends Value {
        @Override
        public void validateKeyType() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public Object getObject() {
            return null;
        }

        public String toString() {
            return "INF";
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass());
        }

        public final int hashCode() {
            return 0;
        }
    }

    public static final class SortedMapValue
    extends Value {
        private final List<? extends Map.Entry<?, ?>> list;
        private byte[] bytes;
        private final MapOrder order;

        public SortedMapValue(List<? extends Map.Entry<?, ?>> list, MapOrder order) {
            this.list = list;
            this.order = order;
        }

        @Override
        public void validateKeyType() {
        }

        @Override
        public int getType() {
            return 19;
        }

        @Override
        public Object getObject() {
            return this.list;
        }

        public String toString() {
            return this.list.toString();
        }

        public boolean equals(Object other) {
            if (other == null || !this.getClass().equals(other.getClass())) {
                return false;
            }
            SortedMapValue o = (SortedMapValue)other;
            return this.order == o.order && this.list.equals(o.list);
        }

        public int hashCode() {
            return this.list.hashCode();
        }
    }

    public static final class MapValue
    extends Value {
        private final Map<?, ?> map;
        private final MapOrder order;
        private byte[] bytes;

        public MapValue(Map<?, ?> map) {
            this.map = map;
            this.order = MapValue.getMapOrder(map);
        }

        public MapValue(Map<?, ?> map, MapOrder order) {
            this.map = map;
            this.order = order;
        }

        public MapOrder getOrder() {
            return this.order;
        }

        @Override
        public void validateKeyType() {
        }

        @Override
        public int getType() {
            return 19;
        }

        @Override
        public Object getObject() {
            return this.map;
        }

        public String toString() {
            return this.map.toString();
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.map.equals(((MapValue)other).map);
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public static MapOrder getMapOrder(Map<?, ?> map) {
            return map instanceof SortedMap ? MapOrder.KEY_ORDERED : MapOrder.UNORDERED;
        }
    }

    public static final class ListValue
    extends Value {
        private final List<?> list;
        private byte[] bytes;

        public ListValue(List<?> list) {
            this.list = list;
        }

        @Override
        public void validateKeyType() {
        }

        @Override
        public int getType() {
            return 20;
        }

        @Override
        public Object getObject() {
            return this.list;
        }

        public String toString() {
            return this.list.toString();
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.list.equals(((ListValue)other).list);
        }

        public int hashCode() {
            return this.list.hashCode();
        }
    }

    public static final class ValueArray
    extends Value {
        private final Value[] array;
        private byte[] bytes;

        public ValueArray(Value[] array) {
            this.array = array;
        }

        @Override
        public void validateKeyType() {
        }

        @Override
        public int getType() {
            return 20;
        }

        @Override
        public Object getObject() {
            return this.array;
        }

        public String toString() {
            return Arrays.toString(this.array);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && Arrays.equals(this.array, ((ValueArray)other).array);
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    public static final class BlobValue
    extends Value {
        private final Object object;
        private byte[] bytes;

        public BlobValue(Object object) {
            this.object = object;
        }

        @Override
        public void validateKeyType() {
        }

        @Override
        public int getType() {
            return 7;
        }

        @Override
        public Object getObject() {
            return this.object;
        }

        public String toString() {
            return BlobValue.bytesToHexString(this.bytes);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.object.equals(((BlobValue)other).object);
        }

        public int hashCode() {
            return this.object.hashCode();
        }
    }

    public static final class BoolIntValue
    extends Value {
        private final boolean value;

        public BoolIntValue(boolean value) {
            this.value = value;
        }

        @Override
        public void validateKeyType() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        public String toString() {
            return Boolean.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((BoolIntValue)other).value;
        }

        public int hashCode() {
            return this.value ? 1231 : 1237;
        }

        @Override
        public Number value() {
            return this.value ? 1L : 0L;
        }
    }

    public static final class BooleanValue
    extends Value {
        private final boolean value;

        public BooleanValue(boolean value) {
            this.value = value;
        }

        @Override
        public void validateKeyType() {
        }

        @Override
        public int getType() {
            return 17;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        public String toString() {
            return Boolean.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((BooleanValue)other).value;
        }

        public int hashCode() {
            return this.value ? 1231 : 1237;
        }

        @Override
        public Number value() {
            return this.value ? 1 : 0;
        }
    }

    public static final class FloatValue
    extends Value {
        private final float value;

        public FloatValue(float value) {
            this.value = value;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public Object getObject() {
            return Float.valueOf(this.value);
        }

        public String toString() {
            return Float.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((FloatValue)other).value;
        }

        public int hashCode() {
            return Float.floatToIntBits(this.value);
        }

        @Override
        public Number value() {
            return Float.valueOf(this.value);
        }
    }

    public static final class DoubleValue
    extends Value {
        private final double value;

        public DoubleValue(double value) {
            this.value = value;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        public String toString() {
            return Double.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((DoubleValue)other).value;
        }

        public int hashCode() {
            long bits = Double.doubleToLongBits(this.value);
            return (int)(bits ^ bits >>> 32);
        }

        @Override
        public Number value() {
            return this.value;
        }
    }

    public static final class LongValue
    extends Value {
        private final long value;

        public LongValue(long value) {
            this.value = value;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        public String toString() {
            return Long.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((LongValue)other).value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        @Override
        public Number value() {
            return this.value;
        }
    }

    public static final class IntegerValue
    extends Value {
        private final int value;

        public IntegerValue(int value) {
            this.value = value;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((IntegerValue)other).value;
        }

        public int hashCode() {
            return this.value;
        }

        @Override
        public Number value() {
            return this.value;
        }
    }

    public static final class StringValue
    extends Value {
        private final String value;

        public StringValue(String value) {
            this.value = value;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value.equals(((StringValue)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static final class ByteValue
    extends Value {
        private final byte value;

        public ByteValue(byte value) {
            this.value = value;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Object getObject() {
            return this.value;
        }

        public String toString() {
            return Byte.toString(this.value);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && this.value == ((ByteValue)other).value;
        }

        public int hashCode() {
            return this.value;
        }

        @Override
        public Number value() {
            return this.value;
        }
    }

    public static final class ByteSegmentValue
    extends Value {
        private final byte[] bytes;
        private final int offset;
        private final int length;

        public ByteSegmentValue(byte[] bytes, int offset, int length) {
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int getType() {
            return 4;
        }

        @Override
        public Object getObject() {
            return this;
        }

        public String toString() {
            return ByteSegmentValue.bytesToHexString(this.bytes, this.offset, this.length);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            ByteSegmentValue other = (ByteSegmentValue)obj;
            if (this.length != other.length) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.bytes[this.offset + i] == other.bytes[other.offset + i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 1;
            for (int i = 0; i < this.length; ++i) {
                result = 31 * result + this.bytes[this.offset + i];
            }
            return result;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }
    }

    public static final class BytesValue
    extends Value {
        private final byte[] bytes;
        private final int type;

        public BytesValue(byte[] bytes) {
            this.bytes = bytes;
            this.type = 4;
        }

        public BytesValue(byte[] bytes, int type2) {
            this.bytes = bytes;
            this.type = type2;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public Object getObject() {
            return this.bytes;
        }

        public String toString() {
            return BytesValue.bytesToHexString(this.bytes);
        }

        public boolean equals(Object other) {
            return other != null && this.getClass().equals(other.getClass()) && Arrays.equals(this.bytes, ((BytesValue)other).bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }

    public static final class NullValue
    extends Value {
        public static final NullValue INSTANCE = new NullValue();

        @Override
        public void validateKeyType() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public Object getObject() {
            return null;
        }

        public String toString() {
            return null;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return true;
            }
            return this.getClass().equals(other.getClass());
        }

        public final int hashCode() {
            return 0;
        }
    }
}

