/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.compute.number;

import io.dingodb.common.operation.Value;
import io.dingodb.common.operation.compute.number.ComputeNumber;
import java.util.Objects;

public class ComputeDouble
implements ComputeNumber<ComputeDouble> {
    private Double value;

    public ComputeDouble() {
    }

    public ComputeDouble(Double value) {
        this.value = value;
    }

    public static ComputeDouble of(Double value) {
        return new ComputeDouble(value == null ? 0.0 : value);
    }

    public static ComputeDouble of(Number value) {
        return new ComputeDouble(value == null ? 0.0 : value.doubleValue());
    }

    public static ComputeDouble of(ComputeNumber<?> computeNumber) {
        return new ComputeDouble(computeNumber.doubleValue());
    }

    @Override
    public ComputeDouble add(ComputeNumber<?> num) {
        this.value = this.value + num.doubleValue();
        return this;
    }

    @Override
    public ComputeDouble subtract(ComputeNumber<?> num) {
        this.value = this.value - num.doubleValue();
        return this;
    }

    @Override
    public ComputeDouble multiply(ComputeNumber<?> num) {
        this.value = this.value * num.doubleValue();
        return this;
    }

    @Override
    public ComputeDouble divide(ComputeNumber<?> num) {
        this.value = this.value / num.doubleValue();
        return this;
    }

    @Override
    public ComputeDouble remainder(ComputeNumber<?> num) {
        this.value = this.value % num.doubleValue();
        return this;
    }

    @Override
    public int signum() {
        return this.value > 0.0 ? 1 : (this.value == 0.0 ? 0 : -1);
    }

    @Override
    public ComputeDouble abs() {
        this.value = this.value <= 0.0 ? 0.0 - this.value : this.value;
        return this;
    }

    @Override
    public ComputeDouble negate() {
        this.value = 0.0 - this.value;
        return this;
    }

    @Override
    public ComputeDouble fastClone() {
        return new ComputeDouble(this.value);
    }

    @Override
    public ComputeDouble value(Value value) {
        this.value = value.value().doubleValue();
        return this;
    }

    @Override
    public Value value() {
        return Value.get(this.value);
    }

    @Override
    public int compareTo(ComputeDouble that) {
        return Double.compare(this.value, that.doubleValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ComputeDouble that = (ComputeDouble)obj;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }
}

