/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.compute.number;

import io.dingodb.common.operation.Value;
import io.dingodb.common.operation.compute.number.ComputeNumber;
import java.util.Objects;

public class ComputeFloat
implements ComputeNumber<ComputeFloat> {
    private Float value;

    public ComputeFloat() {
    }

    public ComputeFloat(Float value) {
        this.value = value;
    }

    public static ComputeFloat of(Float value) {
        return new ComputeFloat(Float.valueOf(value == null ? 0.0f : value.floatValue()));
    }

    public static ComputeFloat of(Number value) {
        return new ComputeFloat(Float.valueOf(value == null ? 0.0f : value.floatValue()));
    }

    public static ComputeFloat of(ComputeNumber<?> computeNumber) {
        return new ComputeFloat(Float.valueOf(computeNumber.floatValue()));
    }

    @Override
    public ComputeFloat add(ComputeNumber<?> num) {
        this.value = Float.valueOf(this.value.floatValue() + num.floatValue());
        return this;
    }

    @Override
    public ComputeFloat subtract(ComputeNumber<?> num) {
        this.value = Float.valueOf(this.value.floatValue() - num.floatValue());
        return this;
    }

    @Override
    public ComputeFloat multiply(ComputeNumber<?> num) {
        this.value = Float.valueOf(this.value.floatValue() * num.floatValue());
        return this;
    }

    @Override
    public ComputeFloat divide(ComputeNumber<?> num) {
        this.value = Float.valueOf(this.value.floatValue() / num.floatValue());
        return this;
    }

    @Override
    public ComputeFloat remainder(ComputeNumber<?> num) {
        this.value = Float.valueOf(this.value.floatValue() % num.floatValue());
        return this;
    }

    @Override
    public int signum() {
        return this.value.floatValue() > 0.0f ? 1 : (this.value.floatValue() == 0.0f ? 0 : -1);
    }

    @Override
    public ComputeFloat abs() {
        this.value = Float.valueOf(this.value.floatValue() <= 0.0f ? 0.0f - this.value.floatValue() : this.value.floatValue());
        return this;
    }

    @Override
    public ComputeFloat negate() {
        this.value = Float.valueOf(0.0f - this.value.floatValue());
        return this;
    }

    @Override
    public ComputeFloat fastClone() {
        return new ComputeFloat(this.value);
    }

    @Override
    public ComputeFloat value(Value value) {
        this.value = Float.valueOf(value.value().floatValue());
        return this;
    }

    @Override
    public Value value() {
        return Value.get(this.value);
    }

    @Override
    public int compareTo(ComputeFloat that) {
        return Float.compare(this.value.floatValue(), that.floatValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ComputeFloat that = (ComputeFloat)obj;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }
}

