/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.compute.number;

import io.dingodb.common.operation.Value;
import io.dingodb.common.operation.compute.number.ComputeNumber;
import java.util.Objects;

public class ComputeInteger
implements ComputeNumber<ComputeInteger> {
    private Integer value;

    public ComputeInteger() {
    }

    public ComputeInteger(Integer value) {
        this.value = value;
    }

    public static ComputeInteger of(Integer value) {
        return new ComputeInteger(value == null ? 0 : value);
    }

    public static ComputeInteger of(Number value) {
        return new ComputeInteger(value == null ? 0 : value.intValue());
    }

    public static ComputeInteger of(ComputeNumber<?> computeNumber) {
        return new ComputeInteger(computeNumber.intValue());
    }

    @Override
    public ComputeInteger value(Value value) {
        this.value = value.value().intValue();
        return this;
    }

    @Override
    public Value value() {
        return Value.get(this.value);
    }

    @Override
    public ComputeInteger add(ComputeNumber<?> num) {
        this.value = this.value + num.intValue();
        return this;
    }

    @Override
    public ComputeInteger subtract(ComputeNumber<?> num) {
        this.value = this.value - num.intValue();
        return this;
    }

    @Override
    public ComputeInteger multiply(ComputeNumber<?> num) {
        this.value = this.value * num.intValue();
        return this;
    }

    @Override
    public ComputeInteger divide(ComputeNumber<?> num) {
        this.value = this.value / num.intValue();
        return this;
    }

    @Override
    public ComputeInteger remainder(ComputeNumber<?> num) {
        this.value = this.value % num.intValue();
        return this;
    }

    @Override
    public int signum() {
        return this.value > 0 ? 1 : (this.value == 0 ? 0 : -1);
    }

    @Override
    public ComputeInteger abs() {
        this.value = this.value < 0 ? -this.value.intValue() : this.value;
        return this;
    }

    @Override
    public ComputeInteger negate() {
        this.value = -this.value.intValue();
        return this;
    }

    @Override
    public ComputeInteger fastClone() {
        return new ComputeInteger(this.value);
    }

    @Override
    public int compareTo(ComputeInteger that) {
        return Integer.compare(this.value, that.intValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ComputeInteger that = (ComputeInteger)obj;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }
}

