/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.common.operation.compute.number;

import io.dingodb.common.operation.Value;
import io.dingodb.common.operation.compute.number.ComputeNumber;
import java.util.Objects;

public class ComputeLong
implements ComputeNumber<ComputeLong> {
    private Long value;

    public ComputeLong() {
    }

    public ComputeLong(Long value) {
        this.value = value;
    }

    public static ComputeLong of(Long value) {
        return new ComputeLong(value == null ? 0L : value);
    }

    public static ComputeLong of(Number value) {
        return new ComputeLong(value == null ? 0L : value.longValue());
    }

    public static ComputeLong of(ComputeNumber<?> computeNumber) {
        return new ComputeLong(computeNumber.longValue());
    }

    @Override
    public ComputeLong value(Value value) {
        this.value = value.value().longValue();
        return this;
    }

    @Override
    public Value value() {
        return Value.get(this.value);
    }

    public ComputeLong inc() {
        Long l = this.value;
        Long l2 = this.value = Long.valueOf(this.value + 1L);
        return this;
    }

    public ComputeLong inc(Long inc) {
        this.value = this.value + inc;
        return this;
    }

    @Override
    public ComputeLong add(ComputeNumber<?> num) {
        this.value = this.value + num.longValue();
        return this;
    }

    @Override
    public ComputeLong subtract(ComputeNumber<?> num) {
        this.value = this.value - num.longValue();
        return this;
    }

    @Override
    public ComputeLong multiply(ComputeNumber<?> num) {
        this.value = this.value * num.longValue();
        return this;
    }

    @Override
    public ComputeLong divide(ComputeNumber<?> num) {
        this.value = this.value / num.longValue();
        return this;
    }

    @Override
    public ComputeLong remainder(ComputeNumber<?> num) {
        this.value = this.value % num.longValue();
        return this;
    }

    @Override
    public int signum() {
        return this.value > 0L ? 1 : (this.value == 0L ? 0 : -1);
    }

    @Override
    public ComputeLong abs() {
        this.value = this.value < 0L ? -this.value.longValue() : this.value;
        return this;
    }

    @Override
    public ComputeLong negate() {
        this.value = -this.value.longValue();
        return this;
    }

    @Override
    public ComputeLong fastClone() {
        return new ComputeLong(this.value);
    }

    @Override
    public int compareTo(ComputeLong that) {
        return Long.compare(this.value, that.longValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ComputeLong that = (ComputeLong)obj;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }
}

